/***************************************************************************
 begin                : Thu Sep 5 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFPROCOUT_H
#define KMFPROCOUT_H

// TQt includes
#include <tqwidget.h>
#include <tqstring.h>
#include <tqpixmap.h>

// KDE includes
#include <kprocess.h>

/**
  *@author Christian Hubinger
  */

class TQLabel;
class TQGridLayout;
class KPushButton;
class TQTextBrowser;
namespace KMF {
class KDE_EXPORT KMFProcOut : public TQWidget {
	TQ_OBJECT
  
public:
	KMFProcOut( TQWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFProcOut();

	bool isRunning();
	void runCmd( const TQString& cmd, const TQString& job_name, const TQString& job_description, bool useKdeSu );
	void setText( const TQString&, const TQString& coomandName);

public slots:
	void slotKillJob();
	
protected slots:
	void slotReceivedOutput( TDEProcess*, char*, int );
	void slotReceivedError( TDEProcess*, char*, int );
	void slotProcessExited( TDEProcess* );

private:
	
	void startJob(  const TQString &dir, bool useKdeSu );
	// void prepareJob( const TQString &dir );
	void childFinished( bool normal, int status );
	void insertStderrLine( const TQString &line );
	void insertStdoutLine( const TQString &line );
	void slotSetButtons();
	void initGUI();

private:    // data
	TQString* stderrbuf;
	TQString* stdoutbuf;
	TDEProcess* childproc;
	
	TQPixmap icon_stop, icon_close;
	TQString m_job_name;
	TQTextBrowser *m_lbview;
	TQLabel *m_ljob_name;
	TQGridLayout *m_layout;
	KPushButton *m_bkill;

signals:
	void processExited( TDEProcess * );
	void rowSelected( int row );
	void sigJobFinished( bool, const TQString& );
};
}
#endif
