/* This file is part of the KDE project
   Copyright (C) 2002-2004 Ariya Hidayat <ariya@kde.org>
             (C) 2002-2003 Norbert Andres <nandres@web.de>
             (C) 2001-2003 Philipp Mueller <philipp.mueller@gmx.de>
             (C) 2002 John Dailey <dailey@vt.edu>
             (C) 1999-2002 Laurent Montel <montel@kde.org>
             (C) 1999-2002 Harri Porten <porten@kde.org>
             (C) 2000-2001 David Faure <faure@kde.org>
             (C) 1998-2000 Torben Weis <weis@kde.org>
             (C) 2000 Werner Trobin <trobin@kde.org>
             (C) 1999 Reginald Stadlbauer <reggie@kde.org>
             (C) 1998-1999 Stephan Kulow <coolo@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __kspread_dlg_layout_h__
#define __kspread_dlg_layout_h__


#include <tqtabdialog.h>
#include <tqapplication.h>
#include <tqbuttongroup.h>
#include <tqgroupbox.h>
#include <knuminput.h>
#include <kcompletion.h>
#include "kspread_view.h"
#include "kspread_format.h"
#include "kspread_doc.h"
#include "kspread_value.h"
#include "position_cell_format.h"
#include "font_cell_format.h"
#include "protection_cell_format.h"

#include <tqpushbutton.h>
#include <tqcheckbox.h>

class KoUnitDoubleSpinBox;
class TQPixmap;
class TQRadioButton;
class TQPushButton;
class TQDate;
class TQTime;
class TQLabel;
class TQWidget;
class KLineEdit;
class TQFrame;
class TQListBox;
class TQCheckBox;
class KColorButton;
class TQComboBox;
class KComboBox;
class KoUnitDoubleSpinBox;

namespace KSpread
{
class Sheet;
class CustomStyle;
class StyleManager;
class CellFormatDialog;
class FormatManipulator;

enum BorderType
{
  BorderType_Top = 0,
  BorderType_Bottom,
  BorderType_Left,
  BorderType_Right,
  BorderType_Vertical,
  BorderType_Horizontal,
  BorderType_FallingDiagonal,
  BorderType_RisingDiagonal,
  BorderType_END
};

enum BorderShortcutType
{
  BorderShortcutType_Remove = 0,
  BorderShortcutType_All,
  BorderShortcutType_Outline,
  BorderShortcutType_END
};

class PatternSelect : public TQFrame
{
    TQ_OBJECT
  
public:
    PatternSelect( TQWidget *parent, const char *_name );

    void setPenStyle( TQt::PenStyle _pat ) { penStyle = _pat; repaint(); }
    TQt::PenStyle getPenStyle() { return penStyle; }
    void setColor( const TQColor &_col ) { penColor = _col; repaint(); }
    const TQColor& getColor() { return penColor; }
    void setPenWidth( int _w ) { penWidth = _w; repaint(); }
    int getPenWidth() { return penWidth; }

    void setPattern( const TQColor &_color, int _width, TQt::PenStyle _style );
    void setUndefined();
    void setDefined() { undefined = FALSE; repaint(); }

    bool isDefined() { return !undefined; }

signals:
    void clicked( PatternSelect *_this );

public slots:
    void slotUnselect();
    void slotSelect();

protected:
    virtual void paintEvent( TQPaintEvent *_ev );
    virtual void mousePressEvent( TQMouseEvent *_ev );

    TQt::PenStyle penStyle;
    TQColor penColor;
    int penWidth;

    bool selected;
    bool undefined;
};

class GeneralTab : public TQWidget
{
  TQ_OBJECT
  

 public:
  GeneralTab( TQWidget * parent, CellFormatDialog * _dlg );
  ~GeneralTab();

  bool apply( CustomStyle * style );

 protected slots:
  void slotNewParent( const TQString & parentName );
  void slotNameChanged();

 private:
  CellFormatDialog * m_dlg;
  KComboBox     * m_parentBox;
  KLineEdit     * m_nameEdit;

  TQString m_name;
  TQString m_parent;

  bool checkParent( const TQString & parentName );
  bool checkName();
};

/**
 */
class CellFormatPageFont : public FontTab
{
    TQ_OBJECT
  
public:
    CellFormatPageFont( TQWidget* parent, CellFormatDialog *_dlg );

    void apply( CustomStyle * style );
    void apply( FormatManipulator *_obj );

signals:
    /**
     * Connect to this to monitor the font as it as selected if you are
     * not running modal.
     */
    void fontSelected( const TQFont &font );

private slots:

    void      family_chosen_slot(const TQString & );
    void      size_chosen_slot(const TQString & );
    void      weight_chosen_slot(const TQString &);
    void      style_chosen_slot(const TQString &);
    void      underline_chosen_slot();
    void      strike_chosen_slot();
    void      display_example(const TQFont &font);
    void      slotSetTextColor( const TQColor &_color );

private:

    void setCombos();
    TQColor textColor;
    TQFont         selFont;
    bool fontChanged;
    bool bTextColorUndefined;
    CellFormatDialog *dlg;
};

/**
 * Format of numbers.
 * This widget is part of the format dialog.
 * It allows the user to cinfigure the way numbers are formatted.
 */
class CellFormatPageFloat : public TQWidget
{
    TQ_OBJECT
  
public:
    CellFormatPageFloat( TQWidget *parent, CellFormatDialog *_dlg );
    void apply( CustomStyle * style );
    void apply( FormatManipulator *_obj );

public slots:
    void slotChangeState();
    void makeformat();
    void updateFormatType();
    void init();
    void slotChangeValue(int);
    void formatChanged(int);
    void currencyChanged(const TQString &);
protected:
    TQLineEdit* postfix;
    KIntNumInput* precision;
    TQLineEdit* prefix;
    TQComboBox *format;
    TQComboBox *currency;
    TQLabel    *currencyLabel;
    TQRadioButton *generic;
    TQRadioButton *number;
    TQRadioButton *percent;
    TQRadioButton *date;
    TQRadioButton *money;
    TQRadioButton *scientific;
    TQRadioButton *fraction;
    TQRadioButton *time;
    TQRadioButton *textFormat;
    TQRadioButton *customFormat;
    TQListBox *listFormat;
    TQLineEdit* customFormatEdit;
    TQLabel *exampleLabel;
    CellFormatDialog *dlg;
    FormatType cellFormatType, newFormatType;
    //test if value changed
    bool m_bFormatTypeChanged;
    bool m_bFormatColorChanged;
};

class CellFormatPagePosition : public PositionTab
{
    TQ_OBJECT
  
public:
    CellFormatPagePosition( TQWidget *parent, CellFormatDialog *_dlg );

    void apply( CustomStyle * style );
    void apply( FormatManipulator *_obj );

    double getSizeHeight() const;
    double getSizeWidth() const;
    bool getMergedCellState() const;

public slots:
    void slotChangeHeightState();
    void slotChangeWidthState();
    void slotChangeAngle(int);
    void slotStateChanged(int);
    void slotChangeVerticalState();
    void slotChangeMultiState();

protected:
    KoUnitDoubleSpinBox *width;
    KoUnitDoubleSpinBox *height;
    KoUnitDoubleSpinBox *m_indent;
    CellFormatDialog *dlg;
    bool m_bOptionText;
};



class Border : public TQFrame
{
    TQ_OBJECT
  
public:
    Border( TQWidget *parent,const char *_name,bool _oneCol,bool _oneRow  );
signals:
    void redraw();
    void choosearea(TQMouseEvent * _ev);
protected:
    virtual void paintEvent( TQPaintEvent *_ev );
    virtual void mousePressEvent( TQMouseEvent* _ev );
    bool oneCol;
    bool oneRow;
};

class BorderButton : public TQPushButton
{
    TQ_OBJECT
  
public:
    BorderButton( TQWidget *parent, const char *_name );
    void setPenStyle( TQt::PenStyle _pat ) { penStyle = _pat;}
    TQt::PenStyle getPenStyle() { return penStyle; }
    void setColor( const TQColor &_col ) { penColor = _col; }
    const TQColor& getColor() { return penColor; }
    void setPenWidth( int _w ) { penWidth = _w; }
    int getPenWidth() { return penWidth; }
    bool isChanged() { return changed; }
    void setChanged(bool _changed ) { changed=_changed;}
    void setUndefined();
    void unselect();
 signals:
    void clicked(BorderButton *);
 protected:
    virtual void mousePressEvent( TQMouseEvent *_ev );
    TQt::PenStyle penStyle;
    TQColor penColor;
    int penWidth;
    bool changed;

};

class CellFormatPageBorder : public TQWidget
{
  TQ_OBJECT
  
public:
    CellFormatPageBorder( TQWidget *parent, CellFormatDialog *_dlg );

    void apply(FormatManipulator* obj);
    void invertState(BorderButton *_button);
    TQPixmap paintFormatPixmap(PenStyle _style);

public slots:
    void changeState(BorderButton *_this);
    void preselect( BorderButton *_this);
    void draw();
    void slotSetColorButton( const TQColor &_color );
    void slotUnselect2( PatternSelect *_select );
    void loadIcon( TQString pix,BorderButton *_button);
    void slotPressEvent(TQMouseEvent *_ev);
    void slotChangeStyle(int );
    void slotChangeStyle(const TQString & );
    void cutomize_chosen_slot();

protected:

  Sheet* sheet;
  BorderButton* borderButtons[BorderType_END];
  BorderButton* shortcutButtons[BorderShortcutType_END];
#define NUM_BORDER_PATTERNS 10

  /* the patterns to choose from */
  PatternSelect* pattern[NUM_BORDER_PATTERNS];

  /* the pattern box that is the 'preview' of what is selected above. */
  PatternSelect* preview;
  TQComboBox* size;
  TQComboBox* style;
  KColorButton* color;
  TQCheckBox* customize;
  TQColor currentColor;
  Border *area;
  CellFormatDialog *dlg;
private:

  /*some helper functions to space some tasks apart */
  void InitializeGrids();
  void InitializeBorderButtons();
  void InitializePatterns();
  void SetConnections();
  void applyTopOutline(FormatManipulator* obj);
  void applyBottomOutline(FormatManipulator* obj);
  void applyLeftOutline(FormatManipulator* obj);
  void applyRightOutline(FormatManipulator* obj);
  void applyVerticalOutline(FormatManipulator* obj);
  void applyHorizontalOutline(FormatManipulator* obj);
  void applyDiagonalOutline(FormatManipulator* obj);
};

class BrushSelect : public TQFrame
{
    TQ_OBJECT
  
public:
    BrushSelect( TQWidget *parent, const char *_name );

    void setBrushStyle( TQt::BrushStyle _pat ) { brushStyle = _pat; repaint(); }
    TQt::BrushStyle getBrushStyle() const { return brushStyle; }
    TQColor getBrushColor() const { return brushColor; }
    void setBrushColor(const TQColor &_c) { brushColor=_c;}
    void setPattern( const TQColor &_color, TQt::BrushStyle _style );

signals:
    void clicked( BrushSelect *_this );

public slots:
    void slotUnselect();
    void slotSelect();

protected:
    virtual void paintEvent( TQPaintEvent *_ev );
    virtual void mousePressEvent( TQMouseEvent *_ev );

    TQt::BrushStyle brushStyle;
    TQColor brushColor;
    bool selected;
};


class CellFormatPagePattern : public TQWidget
{
    TQ_OBJECT
  
public:
    CellFormatPagePattern( TQWidget *parent, CellFormatDialog *_dlg );

    void apply( CustomStyle * style );
    void apply( FormatManipulator *_obj );

    void init();
public slots:
    void slotUnselect2( BrushSelect *_select );
    void slotSetColorButton( const TQColor &_color );
    void slotSetBackgroundColor( const TQColor &_color );
    void slotNotAnyColor( );
protected:
    BrushSelect *selectedBrush;
    BrushSelect *brush1;
    BrushSelect *brush2;
    BrushSelect *brush3;
    BrushSelect *brush4;
    BrushSelect *brush5;
    BrushSelect *brush6;
    BrushSelect *brush7;
    BrushSelect *brush8;
    BrushSelect *brush9;
    BrushSelect *brush10;
    BrushSelect *brush11;
    BrushSelect *brush12;
    BrushSelect *brush13;
    BrushSelect *brush14;
    BrushSelect *brush15;
    BrushSelect *current;
    KColorButton* color;
    TQPushButton* notAnyColor;
    TQColor currentColor;

    TQColor bgColor;
    bool bBgColorUndefined;
    KColorButton *bgColorButton;
    bool b_notAnyColor;
    CellFormatDialog *dlg;
};

class CellFormatPageProtection : public ProtectionTab
{
  TQ_OBJECT
  

 public:
  CellFormatPageProtection( TQWidget * parent, CellFormatDialog * _dlg );
  ~CellFormatPageProtection();
  ///when protection is set through Style Manager
  void apply( CustomStyle * style );
  void apply( FormatManipulator * _obj );

 protected:
  CellFormatDialog * m_dlg;
  bool            m_isProtected;
  bool            m_hideFormula;
  bool            m_hideAll;
  bool            m_dontPrint;
};

/**
 * Dialog for the "Cell Format..." action
 */
class CellFormatDialog : public TQObject
{
    TQ_OBJECT
  
public:
    /**
     * Create a format dlg for the rectangular area in '_sheet'.
     */
    CellFormatDialog( View * _view, Sheet * _sheet );
    CellFormatDialog( View * _view, CustomStyle * _style, StyleManager * _manager,
                   Doc * doc );

    ~CellFormatDialog();

    void init();
    void initGUI();
    void initMembers();

    void initParameters(Format *_obj,int column,int row);
    void checkBorderRight(Format *obj,int x,int y);
    void checkBorderLeft(Format *obj,int x,int y);
    void checkBorderTop(Format *obj,int x,int y);
    void checkBorderBottom(Format *obj,int x,int y);
    void checkBorderVertical(Format *obj,int x,int y);
    void checkBorderHorizontal(Format *obj,int x,int y);
    /**
     * Run the dialogs event loop and return when closed.
     */
    int exec();

    Doc * getDoc() const { return m_doc; }
    Sheet * getSheet() const { return m_sheet; }
    CustomStyle * getStyle() const { return m_style; }
    StyleManager * getStyleManager() const { return m_styleManager; }

    bool isSingleCell() { return ( left == right && top == bottom ); }
    bool checkCircle( TQString const & name, TQString const & parent );

    TDELocale * locale() const { return m_pView->doc()->locale(); }


    struct CellBorderFormat
    {
      int width;
      bool bStyle;
      TQColor color;
      bool bColor;
      TQt::PenStyle style;
    };

    // The format of the selected area
    CellBorderFormat borders[BorderType_END];

    TQt::BrushStyle brushStyle;
    TQColor brushColor;

    bool oneCol;
    bool oneRow;

    TQString prefix;
    TQString postfix;
    int precision;
    Format::FloatFormat floatFormat;
    bool bFloatFormat;
    Format::FloatColor floatColor;
    Format::Currency   cCurrency;
    bool bFloatColor;
    bool bCurrency;
    TQColor textColor;
    bool bTextColor;
    bool bTextFontBold;
    bool textFontBold;
    bool bTextFontItalic;
    bool textFontItalic;
    bool bTextFontSize;
    int textFontSize;
    bool bTextFontFamily;
    TQString textFontFamily;
    bool bStrike;
    bool strike;
    bool bUnderline;
    bool underline;
    TQFont textFont;
    TQColor bgColor;
    bool bBgColor;
    TQString actionText;
    Format::Align alignX;
    Format::AlignY alignY;
    TQString styleName;
    TQString styleParent;

    bool bMultiRow;
    bool bVerticalText;

    bool bDontPrintText;
    bool bHideFormula;
    bool bHideAll;
    bool bIsProtected;

    double defaultHeightSize;
    double defaultWidthSize;
    double heightSize;
    double widthSize;

    double indent;

    TQPixmap* formatOnlyNegSignedPixmap;
    TQPixmap* formatRedOnlyNegSignedPixmap;
    TQPixmap* formatRedNeverSignedPixmap;
    TQPixmap* formatAlwaysSignedPixmap;
    TQPixmap* formatRedAlwaysSignedPixmap;

    int textRotation;
    bool bTextRotation;

    FormatType formatType;
    bool bFormatType;

    Value value;

    bool isMerged;
    bool oneCell;

    bool isRowSelected;
    bool isColumnSelected;

    // The rectangular area for which this dlg has been opened.
    int left;
    int right;
    int top;
    int bottom;


public slots:
    void slotApply();

protected:

    /**
     * Draws a pixmap showing a text consisting of two parts, @p _string1 and @p _string2 .
     * The parts' colors are given by @p _color1 and @p _color2 .
     */
    TQPixmap* paintFormatPixmap( const char *_string1, const TQColor & _color1,
				const char *_string2, const TQColor & _color2 );

    GeneralTab * generalPage;
    CellFormatPageFloat *floatPage;
    CellFormatPageBorder *borderPage;
    CellFormatPageFont *fontPage;
    CellFormatPagePosition *positionPage;
    CellFormatPagePattern *patternPage;
    CellFormatPageProtection *protectPage;
    TQTabDialog *tab;

    Doc   * m_doc;
    Sheet * m_sheet;
    View  * m_pView;
    CustomStyle * m_style;
    StyleManager * m_styleManager;

    void applyStyle();
};

} // namespace KSpread

#endif
