/* This file is part of the KDE project
   Copyright (C) 2002 Peter Simonsson <psn@linux.se>
   Copyright (C) 2004, 2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _KEXIBLOBTABLEEDIT_H_
#define _KEXIBLOBTABLEEDIT_H_

#include <tqcstring.h>
#include <tqcache.h>

#include <kurl.h>

#include "kexitableedit.h"
#include "kexicelleditorfactory.h"

class KTempFile;
class TDEProcess;
class TQTextEdit;

class KexiBlobTableEdit : public KexiTableEdit
{
	TQ_OBJECT
  
	public:
		KexiBlobTableEdit(KexiTableViewColumn &column, TQWidget *parent=0);
		virtual ~KexiBlobTableEdit();

		bool valueIsNull();
		bool valueIsEmpty();

		virtual TQVariant value();

		virtual bool cursorAtStart();
		virtual bool cursorAtEnd();

		/*! Reimplemented: resizes a view(). */
		virtual void resize(int w, int h);

		virtual void showFocus( const TQRect& r, bool readOnly );

		virtual void hideFocus();

		/*! \return total size of this editor, including popup button. */
		virtual TQSize totalSize() const;

		virtual void paintFocusBorders( TQPainter *p, TQVariant &, int x, int y, int w, int h );

		/*! Reimplemented to handle the key events. */
		virtual bool handleKeyPress( TQKeyEvent* ke, bool editorActive );

		/*! Handles double click request coming from the table view. 
		 \return true if it has been consumed. 
		 Reimplemented in KexiBlobTableEdit (to execute "insert file" action. */
		virtual bool handleDoubleClick();

		/*! Handles action having standard name \a actionName. 
		 Action could be: "edit_cut", "edit_paste", etc. */
		virtual void handleAction(const TQString& actionName);

		/*! Handles copy action for value. The \a value is copied to clipboard in format appropriate 
		 for the editor's impementation, e.g. for image cell it can be a pixmap. 
		 \a visibleValue is unused here. Reimplemented after KexiTableEdit. */
		virtual void handleCopyAction(const TQVariant& value, const TQVariant& visibleValue);

		virtual void setupContents( TQPainter *p, bool focused, const TQVariant& val, 
			TQString &txt, int &align, int &x, int &y_offset, int &w, int &h );

	protected slots:
		void slotUpdateActionsAvailabilityRequested(bool& valueIsNull, bool& valueIsReadOnly);

		void handleInsertFromFileAction(const KURL& url);
		void handleAboutToSaveAsAction(TQString& origFilename, TQString& fileExtension, bool& dataIsEmpty);
		void handleSaveAsAction(const TQString& fileName);
		void handleCutAction();
		void handleCopyAction();
		void handlePasteAction();
		virtual void clear();
		void handleShowPropertiesAction();

	protected:
		//! initializes this editor with \a add value
		virtual void setValueInternal(const TQVariant& add, bool removeOld);

		//todo TQString openWithDlg(const TQString& file);
		//todo void execute(const TQString& app, const TQString& file);

		//! @internal
		void updateFocus( const TQRect& r );

		void signalEditRequested();

		//! @internal
		void executeCopyAction(const TQByteArray& data);

		virtual bool eventFilter( TQObject *o, TQEvent *e );

		class Private;
		Private *d;
//todo		KTempFile* m_tempFile;
//todo		TDEProcess* m_proc;
//todo		TQTextEdit *m_content;
};

KEXI_DECLARE_CELLEDITOR_FACTORY_ITEM(KexiBlobEditorFactoryItem)


//=======================
//This class is temporarily here:

/*! @short Cell editor for displaying kde icon (using icon name provided as string).
 Read only.
*/
class KexiTDEIconTableEdit : public KexiTableEdit
{
	public:
		KexiTDEIconTableEdit(KexiTableViewColumn &column, TQWidget *parent=0);

		virtual ~KexiTDEIconTableEdit();

		//! \return true if editor's value is null (not empty)
		virtual bool valueIsNull();

		//! \return true if editor's value is empty (not null). 
		//! Only few field types can accept "EMPTY" property 
		//! (check this with KexiDB::Field::hasEmptyProperty()), 
		virtual bool valueIsEmpty();

		virtual TQVariant value();

		virtual bool cursorAtStart();
		virtual bool cursorAtEnd();

		virtual void clear();

		virtual void setupContents( TQPainter *p, bool focused, const TQVariant& val, 
			TQString &txt, int &align, int &x, int &y_offset, int &w, int &h );

		/*! Handles copy action for value. Does nothing.
		 \a visibleValue is unused here. Reimplemented after KexiTableEdit. */
		virtual void handleCopyAction(const TQVariant& value, const TQVariant& visibleValue);

	protected:
		//! initializes this editor with \a add value
		virtual void setValueInternal(const TQVariant& add, bool removeOld);

		void showHintButton();
		void init();

		class Private;
		Private *d;
};

KEXI_DECLARE_CELLEDITOR_FACTORY_ITEM(KexiTDEIconTableEditorFactoryItem)

#endif
