/* This file is part of the KDE project
   Copyright (C) 2003 Joseph Wenninger <jowenn@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kexicontexthelp.h"
#include <KoContextCelp.h>
#include <kxmlguiclient.h>
#include <tdeapplication.h>
#include <tdelocale.h>
#include <tdeaction.h>
#include <tqlayout.h>
#include <kdebug.h>
#include <kiconloader.h>

KexiContextHelp::KexiContextHelp(KexiMainWindow *view, TQWidget *parent)
	:KoContextHelpWidget(parent,"kexi_contexthelp")
{
	kdDebug()<<"KexiContextHelp::KexiContextHelp()"<<endl;
	setCaption(i18n("Context Help"));
	setIcon(SmallIcon("help"));
	connect(this,TQ_SIGNAL(linkClicked( const TQString& )),
		this,TQ_SLOT(linkClickedInternal( const TQString& )));
}

void KexiContextHelp::linkClickedInternal(const TQString& link) {
	kdDebug()<<"KexiContextHelp: Link: "<<link<<endl;
	unhandledLink(link);
}

KexiContextHelp::~KexiContextHelp()
{
}

#include "kexicontexthelp.moc"
