/* This file is part of the KDE project
   Copyright (C) 1998, 1999, 2000 Torben Weis <weis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "example_view.h"
#include "example_factory.h"
#include "example_part.h"

#include <tqpainter.h>
#include <tqiconset.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <tdelocale.h>
#include <kdebug.h>

ExampleView::ExampleView( ExamplePart* part, TQWidget* parent, const char* name )
    : KoView( part, parent, name )
{
    setInstance( ExampleFactory::global() );
    if ( !part->isReadWrite() ) // readonly case, e.g. when embedded into konqueror
        setXMLFile( "example_readonly.rc" ); // simplified GUI
    else
        setXMLFile( "example.rc" );
    KStdAction::copy(this, TQ_SLOT( copy() ), actionCollection(), "copy" );
    KStdAction::cut(this, TQ_SLOT( cut() ), actionCollection(), "cut" );
    // Note: Prefer KStdAction::* to any custom action if possible.
    //m_cut = new TDEAction( i18n("&Cut"), "edit-cut", 0, this, TQ_SLOT( cut() ),
    //                   actionCollection(), "cut");
}

void ExampleView::paintEvent( TQPaintEvent* ev )
{
    TQPainter painter;
    painter.begin( this );

    // ### TODO: Scaling

    // Let the document do the drawing
    koDocument()->paintEverything( painter, ev->rect(), FALSE, this );

    painter.end();
}

void ExampleView::updateReadWrite( bool /*readwrite*/ )
{
#ifdef __GNUC__
#warning TODO
#endif
}

void ExampleView::copy()
{
    kdDebug(31000) << "ExampleView::copy(): COPY called" << endl;
}

void ExampleView::cut()
{
    kdDebug(31000) << "ExampleView::cut(): CUT called" << endl;
}

#include "example_view.moc"
