/***************************************************************************
*   Copyright (C) 2006 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KLOMANAGER_H
#define KLOMANAGER_H

#include <ntqdom.h>
#include <ntqfont.h>

#include "datablocks/kreborder.h"

class KLOManager
{
public:
	KLOManager();
	virtual ~KLOManager();

	static TQStringList classes();

protected:
	void processDocument( const TQDomDocument & );

	virtual void loadBackgroundColor( const TQString &/*obj*/, const TQColor& ){};
	virtual void loadFont( const TQString &/*obj*/, const TQFont& ){};
	virtual void loadTextColor( const TQString &/*obj*/, const TQColor& ){};
	virtual void loadVisibility( const TQString &/*obj*/, bool ){};
	virtual void loadAlignment( const TQString &/*obj*/, int ){};
	virtual void loadBorder( const TQString &/*obj*/, const KreBorder& ){};
	virtual void loadColumns( const TQString &/*obj*/, int ){};

	virtual void beginObject( const TQString &/*obj*/ ){};
	virtual void endObject(){};

	bool getBoolAttribute( const TQDomElement &obj, const TQString &attr, bool defaultValue = true ) const;
	TQColor getColorAttribute( const TQDomElement &obj, const TQString &attr, const TQColor &defaultValue = TQt::white ) const;
	TQString getTextAttribute( const TQDomElement &obj, const TQString &attr, const TQString &defaultValue = TQString::null ) const;
	int getIntAttribute( const TQDomElement &obj, const TQString &attr, int defaultValue = 0 ) const;
	KreBorder getBorderAttribute( const TQDomElement &obj, const TQString &attr, const KreBorder &defaultValue = KreBorder() ) const;
	TQFont getFontAttribute( const TQDomElement &obj, const TQString &attr, const TQFont &defaultValue = TQFont() ) const;

	TQString alignmentAsCSS( int );
	TQString borderAsCSS( const KreBorder & );
	TQString bgColorAsCSS( const TQColor & );
	TQString fontAsCSS( const TQFont & );
	TQString textColorAsCSS( const TQColor & );
	TQString visibilityAsCSS( bool );

private:
	TQDomElement getLayoutAttribute( const TQDomElement &obj, const TQString &attr ) const;
};

#endif //KLOMANAGER_H
