/***************************************************************************
                          tabmanager.cpp  -  description
                             -------------------
    begin                : Sat Sep 14 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tabmanager.moc"
#include "resource.h"
#include <kdebug.h>

static TQString myConfigGroup( "TabManager" );

TabManager::TabManager( resource *rsrc ) : TQObject()
{
	myResource = rsrc;
	appConfig = kapp->config();
}

TabManager::~TabManager()
{
}

///////////////////////////////////////
//
//	TabManager::addTab
//
///////////////////////////////////////
void TabManager::addTab( TQWidget *child, const TQString &caption )
{
	TabBox *boxPtr;

	if( myList.count() == 0 )
	{
		/* First Tab always generates a new TabBox */
		boxPtr = new TabBox( myResource );
		manageNewBox( boxPtr );
		boxPtr->addTab( child, caption );

		/* Get Geometry from Saved Config */
		appConfig->setGroup( myConfigGroup );
		TQSize defaultSize( 420, 360 );
		TQSize newSize = appConfig->readSizeEntry( TQString( child->className() ), &defaultSize );
		boxPtr->resize( newSize );
		boxPtr->show();
	}
	else
	{
		boxPtr = myList.at(0);
		boxPtr->addTab( child, caption );
	}
}
///////////////////////////////////////
//
//	TabManager::changeCaption
//
///////////////////////////////////////
void TabManager::changeCaption( TQWidget *child, const TQString &caption )
{
	TabBox *boxPtr = getParentBox( child );

	if( boxPtr != NULL )
	{
		boxPtr->changeCaption( child, caption );
	}
}
///////////////////////////////////////
//
//	TabManager::removeTab
//
///////////////////////////////////////
void TabManager::removeTab( TQObject *child )
{
	/* Make sure this is a TQWidget we can manipulate */
	if( !child->isWidgetType() )
	{
		kdError() << "TabManager::removeTab: Can not remove non-widget class " << child->className() << endl;
		return;
	}

	if( myList.find( ((TabBox*)child) ) != -1 )
	{
		/* Remove Child Directly */
		myList.remove( ((TabBox*)child) );
		return;
	}

	TQString childName( ((TQWidget*)child)->className() );
	TabBox *boxPtr = getParentBox( ((TQWidget*)child) );

	/* Remove this Child's Parent, the TabPage */
	if( boxPtr != NULL )
	{
		kdDebug() << "Removing child: " << childName << endl;
		boxPtr->removeTab( ((TQWidget*)child), TRUE );
		if( boxPtr->count() == 0 )
		{
			myList.remove( boxPtr );
			delete boxPtr;
		}
		return;
	}
	kdWarning() << "Could not find child: " << childName << endl;
}
///////////////////////////////////////
//
//	TabManager::showTab
//
///////////////////////////////////////
void TabManager::showTab( TQWidget *child )
{
	TabBox *boxPtr = getParentBox( child );
	if( boxPtr != NULL )
	{
		boxPtr->showTab( child );
	}
}
///////////////////////////////////////
//
//	TabManager::isTab
//
///////////////////////////////////////
bool TabManager::isTab( TQWidget *child )
{
	if( getParentBox( child ) == NULL )
	{
		return FALSE;
	}
	return TRUE;
}
///////////////////////////////////////
//
//	TabManager::saveTabGeometry
//
///////////////////////////////////////
void TabManager::saveTabGeometry( const TQString &childName, const TQSize &childSize )
{
	/* Save This Widget's Size For Later */
	appConfig->setGroup( myConfigGroup );
	appConfig->writeEntry( childName, childSize );
	appConfig->sync();

	kdDebug() << "Saved geometry for Widget: " << childName << endl;
}
///////////////////////////////////////
//
//	TabManager::childEvent
//
///////////////////////////////////////
void TabManager::childEvent( TQChildEvent *event )
{
	if( event->inserted() )
	{
		/* New Child */
		if( TQString( event->child()->className() ) == "TabBox" )
		{
			manageNewBox( ((TabBox*)event->child()) );
			return;
		}
		addTab( ((TQWidget*)event->child()), TQString( "Untitled" ) );
	}
}
///////////////////////////////////////
//
//	TabManager::manageNewBox
//
///////////////////////////////////////
void TabManager::manageNewBox( TabBox *newBox )
{
	myList.append( newBox );
	connect( newBox, TQ_SIGNAL( destroyed( TQObject* ) ), this, TQ_SLOT( removeTab( TQObject* ) ) );
	connect( newBox, TQ_SIGNAL( saveTabGeometry( const TQString&, const TQSize& ) ), this, TQ_SLOT( saveTabGeometry( const TQString&, const TQSize& ) ) );
	connect( newBox, TQ_SIGNAL( newTabBox( TabBox* ) ), this, TQ_SLOT( manageNewBox( TabBox* ) ) );
}
///////////////////////////////////////
//
//	TabManager::getParentBox
//
///////////////////////////////////////
TabBox* TabManager::getParentBox( TQWidget *child )
{
	TabBox *boxPtr;
	for( unsigned int index=0; index < myList.count(); index++ )
	{
		boxPtr = myList.at(index);
		if( boxPtr->isChild( child ) )
		{
			return boxPtr;
		}
	}
	return NULL;
}
