/***************************************************************************
                          tab_seeklist.cpp  -  description
                             -------------------
    begin                : Sat Sep 14 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tab_seeklist.moc"
#include "resource.h"
#include <kiconloader.h>
#include <tqregexp.h>

tab_SeekList::tab_SeekList(TQWidget *parent, const char *name, resource *Rsrc ) : TDEListView(parent,name)
{
	myResource = Rsrc;
	seek = FALSE;
	addColumn( i18n( "Name" ) );
	addColumn( i18n( "Rating" ) );
	addColumn( i18n( "Match Type" ) );
	addColumn( i18n( "Is Rated?" ) );
	addColumn( i18n( "Base Time" ) );
	addColumn( i18n( "Increment" ) );
	setShowSortIndicator( TRUE );
	setAllColumnsShowFocus( TRUE );
	setMultiSelection( FALSE );
	restoreLayout( kapp->config(), "Sought_ListView" );

	menuSeek = new TDEPopupMenu( this );
	menuSeek->setCheckable( TRUE );
	menuSeek->insertItem( i18n("Seek Matches"), this, TQ_SLOT( menuFunct(int) ), 0, MENU_SEEK );
	menuSeek->insertSeparator();
	menuSeek->insertItem( i18n("Accept This Match"), this, TQ_SLOT( menuFunct(int) ), 0, MENU_ACCEPT_MATCH );
	menuSeek->insertItem( i18n("Tell..."), this, TQ_SLOT( menuFunct(int) ), 0, MENU_TELL );
	menuSeek->insertItem( i18n("Assess..."), this, TQ_SLOT( menuFunct(int) ), 0, MENU_ASSESS );
	menuSeek->insertItem( i18n("Player Info"), this, TQ_SLOT( menuFunct(int) ), 0, MENU_FINGER );
	menuSeek->insertItem( TQIconSet( myResource->LoadIcon( TQString("history"), TDEIcon::Small ) ),
												i18n("Player History"), this, TQ_SLOT( menuFunct(int) ), 0, MENU_HISTORY );
	menuSeek->insertSeparator();
	menuSeek->insertItem( i18n("Add to Friends"), this, TQ_SLOT( menuFunct(int) ), 0, MENU_NOTIFY );
	menuSeek->insertItem( i18n("Ignore This Player"), this, TQ_SLOT( menuFunct(int) ), 0, MENU_CENSOR );
	menuSeek->setItemChecked( MENU_SEEK, FALSE );

	connect( this, TQ_SIGNAL( contextMenuRequested( TQListViewItem*, const TQPoint&, int ) ),
						this, TQ_SLOT( display_menuSeek( TQListViewItem*, const TQPoint&, int ) ) );
	connect( this, TQ_SIGNAL( executed( TQListViewItem* ) ),
						this, TQ_SLOT( selectMatch( TQListViewItem* ) ) );
}
tab_SeekList::~tab_SeekList()
{
}
///////////////////////////////////////
//
//	tab_SeekList::recvCMD
//
///////////////////////////////////////
void tab_SeekList::recvCMD( const Command& command )
{
	switch(((Command)command).getCommand())
	{
		case CMD_Add_Sought_Match:
			addSoughtItem( ((Command)command).getData() );
			break;
		case CMD_Show_Sought_List:
			updateSoughtList();
			break;
		case CMD_Hide_Sought_List:
			clear();
			seek = FALSE;
			break;
		default:
			break;
	}
}
///////////////////////////////////////
//
//	tab_SeekList::updateSoughtList
//
///////////////////////////////////////
void tab_SeekList::updateSoughtList( void )
{
	unsigned int loop;

	clear();
	for( loop = 0; loop < SF_01.count(); loop++ )
	{
		(void) new TDEListViewItem( this,
															SF_01[loop],
															SF_02[loop],
															SF_03[loop],
															SF_04[loop],
															SF_05[loop] + i18n(" min."),
															SF_06[loop] + i18n(" sec."),
															SF_07[loop] );
	}
	SF_01.clear();
	SF_02.clear();
	SF_03.clear();
	SF_04.clear();
	SF_05.clear();
	SF_06.clear();
	SF_07.clear();
	seek = TRUE;
}
///////////////////////////////////////
//
//	tab_SeekList::addSoughtItem
//
///////////////////////////////////////
void tab_SeekList::addSoughtItem( const TQString &src )
{
	TQStringList fields = TQStringList::split( TQChar(' '), src, FALSE );
	SF_01 << fields[2]; // Name
	SF_02 << fields[1]; // Rating
	SF_03 << fields[6]; // Match Type
	SF_04 << fields[5]; // Is Rated?
	SF_05 << fields[3]; // Base Time
	SF_06 << fields[4]; // Increment
	SF_07 << fields[0]; // ID#
}
///////////////////////////////////////
//
//	tab_SeekList::display_menuSeek
//
///////////////////////////////////////
void tab_SeekList::display_menuSeek( TQListViewItem *Item, const TQPoint &Pos, int )
{
	bool enable;
	if( Item != NULL )
	{
		setSelected( Item, TRUE );
		selectedPlayerName = Item->text(0).replace( TQRegExp("\\(.+\\)"), TQString("") );
		selectedMatchID = Item->text(6).toInt();
		enable = TRUE;
	}
	else
	{
		enable = FALSE;
	}
	menuSeek->setItemChecked( MENU_SEEK, seek );
	menuSeek->setItemEnabled( MENU_FINGER, enable );
	menuSeek->setItemEnabled( MENU_TELL, enable );
	menuSeek->setItemEnabled( MENU_NOTIFY, enable );
	menuSeek->setItemEnabled( MENU_CENSOR, enable );
	menuSeek->setItemEnabled( MENU_HISTORY, enable );
	menuSeek->setItemEnabled( MENU_ACCEPT_MATCH, enable );
	menuSeek->setItemEnabled( MENU_ASSESS, enable );
	menuSeek->popup( Pos );
}
///////////////////////////////////////
//
//	tab_SeekList::selectMatch
//
///////////////////////////////////////
void tab_SeekList::selectMatch( int matchID )
{
	if( matchID )
		emit sendCMD( Command( 0, CMD_Start_Match, TQString::number( matchID ) ) );
}
void tab_SeekList::selectMatch( TQListViewItem *Item )
{
	selectMatch( Item->text(6).toInt() );
}
///////////////////////////////////////
//
//	tab_SeekList::menuFunct
//
///////////////////////////////////////
void tab_SeekList::menuFunct( int funct )
{
	switch( funct )
	{
		case MENU_SEEK:
			emit sendCMD( Command( 0, CMD_Toggle_Seek ) );
			break;
		case MENU_FINGER:
			emit sendCMD( Command( 0, CMD_Player_Finger, selectedPlayerName ) );
			break;
		case MENU_TELL:
			emit sendCMD( Command( 0, CMD_Set_Input, TQString( "tell %1 " ).arg( selectedPlayerName ) ) );
			break;
		case MENU_NOTIFY:
			emit sendCMD( Command( 0, CMD_Add_Friend, selectedPlayerName ) );
			break;
		case MENU_CENSOR:
			emit sendCMD( Command( 0, CMD_Ignore_Player, selectedPlayerName ) );
			break;
		case MENU_HISTORY:
			emit sendCMD( Command( 0, CMD_Player_History, selectedPlayerName ) );
			break;
		case MENU_ACCEPT_MATCH:
			emit sendCMD( Command( 0, CMD_Start_Match, TQString::number( selectedMatchID ) ) );
			break;
		case MENU_ASSESS:
			emit sendCMD( Command( 0, CMD_Assess, selectedPlayerName ) );
			break;
		default:
			break;
	}
}
