/***************************************************************************
 *   Copyright (C) 2005-2007 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "toplevel_ui.h"

#include <tqstyle.h>
#include <kiconloader.h>

#include "progs/list/prog_list.h"
#include "tools/list/tool_list.h"

//----------------------------------------------------------------------------
ProgrammerStatusWidget::ProgrammerStatusWidget(TQWidget *parent)
  : TQObject(parent), KeyPopupButton<TQString>(parent)
{
  connect(widget(), TQ_SIGNAL(activated(int)), TQ_SLOT(activatedSlot(int)));
  widget()->appendAction(i18n("Configure..."), "configure", this, TQ_SIGNAL(configure()));
  widget()->appendSeparator();
  Programmer::Lister::ConstIterator it;
  for (it=Programmer::lister().begin(); it!=Programmer::lister().end(); ++it)
    appendItem(it.key(), it.data()->label());
}

void ProgrammerStatusWidget::activatedSlot(int id)
{
  emit selected(*Programmer::lister().group(key(id)));
}

//----------------------------------------------------------------------------
ToolStatusWidget::ToolStatusWidget(TQWidget *parent)
  : TQObject(parent), KeyPopupButton<TQString>(parent)
{
  connect(widget(), TQ_SIGNAL(activated(int)), TQ_SLOT(activatedSlot(int)));
  widget()->appendAction(i18n("Configure Toolchain..."), "configure", this, TQ_SIGNAL(configureToolchain()));
  widget()->appendAction(i18n("Configure Compilation..."), "configure", this, TQ_SIGNAL(configure()));
  widget()->appendSeparator();
  Tool::Lister::ConstIterator it;
  for (it=Tool::lister().begin(); it!=Tool::lister().end(); ++it)
    appendItem(it.key(), it.data()->label());
}

void ToolStatusWidget::activatedSlot(int id)
{
  emit selected(*Tool::lister().group(key(id)));
}

//----------------------------------------------------------------------------
ViewMenuAction::ViewMenuAction(KDockWidget *widget)
  : TDEToggleAction(widget->tabPageLabel()), _widget(widget)
{}

void ViewMenuAction::slotActivated()
{
  TDEAction::slotActivated();
  emit activated(_widget);
}

//----------------------------------------------------------------------------
MenuBarButton::MenuBarButton(const TQString &icon, TQWidget *parent)
  : TQToolButton(parent, "menu_bar_button")
{
  TQFontMetrics fm(font());
  int h = fm.height() + 2*style().pixelMetric(TQStyle::PM_DefaultFrameWidth, this);
  setFixedHeight(h);
  TDEIconLoader loader;
  setIconSet(loader.loadIconSet(icon, TDEIcon::Small, fm.height()-2));
  setUsesTextLabel(false);
  setAutoRaise(true);
}

TQSize MenuBarButton::sizeHint() const
{
  return TQSize(TQToolButton::sizeHint().width(), height());
}
