/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Wed Jun 18 2003
 */


#ifndef HIERARCHICALCODEBLOCK_H
#define HIERARCHICALCODEBLOCK_H

#include <tqmap.h>
#include <tqstring.h>

#include "codegenobjectwithtextblocks.h"
#include "codeblockwithcomments.h"
#include "codeclassfieldlist.h"

class HierarchicalCodeBlock : public CodeBlockWithComments, public CodeGenObjectWithTextBlocks
{
    TQ_OBJECT
  
    friend class CodeGenObjectWithTextBlocks;
public:

    // Constructors/Destructors
    //

    /**
     * Constructor
     */
    explicit HierarchicalCodeBlock ( CodeDocument * doc , const TQString &startString = "", const TQString &endString = "", const TQString &comment = "");

    /**
     * Empty Destructor
     */
    virtual ~HierarchicalCodeBlock ( );

    // Public attributes
    //

    // Public attribute accessor methods
    //

    /**
     * Set the value of m_endText
     * @param new_var the new value of m_endText
     */
    void setEndText ( const TQString &new_var );

    /**
     * Get the value of m_endText
     * @return the value of m_endText
     */
    TQString getEndText ( );

    /**
     * Add a TextBlock object to the m_textblockVector List
     */
    bool addTextBlock ( TextBlock * add_object );

    /**
     * Insert a new text block before/after the existing text block. Returns
     * false if it cannot insert the textblock.
     */
    bool insertTextBlock (TextBlock * newBlock, TextBlock * existingBlock, bool after = true);

    /**
     * Remove a TextBlock object from m_textblockVector List
     * returns boolean - true if successful
     */
    bool removeTextBlock ( TextBlock * remove_object );

    /**
     * @param   text
     */
    void setStartText ( const TQString &text );

    /**
     * @return  TQString
     */
    TQString getStartText ( );

    /**
     * Save the XMI representation of this object
     */
    virtual void saveToXMI ( TQDomDocument & doc, TQDomElement & root );

    /**
     * load params from the appropriate XMI element node.
     */
    virtual void loadFromXMI ( TQDomElement & root );

    /**
     * @return  TQString
     */
    virtual TQString toString ( );

    // return a unique, and currently unallocated, text block tag for this hblock
    TQString getUniqueTag();
    TQString getUniqueTag( const TQString& prefix );

    /**
     * Utility method to add accessormethods in this object
     */
    void addCodeClassFieldMethods ( CodeClassFieldList &list );

    virtual CodeBlock * newCodeBlock();
    virtual CodeBlockWithComments * newCodeBlockWithComments();
    virtual HierarchicalCodeBlock * newHierarchicalCodeBlock();

protected:

    /** causes the text block to release all of its connections
    * and any other text blocks that it 'owns'.
    * needed to be called prior to deletion of the textblock.
    */
    virtual void release ();

    /** set attributes of the node that represents this class
     * in the XMI document.
     */
    virtual void setAttributesOnNode (TQDomDocument & doc, TQDomElement & elem );

    /** set the class attributes of this object from
     * the passed element node.
     */
    virtual void setAttributesFromNode ( TQDomElement & element);

    /** set the class attributes from a passed object
     */
    virtual void setAttributesFromObject (TextBlock * obj);

    // look for specific text blocks which belong to code classfields
    TextBlock * findCodeClassFieldTextBlockByTag ( const TQString &tag );

private:

    TQString m_startText;
    TQString m_endText;

    TQString childTextBlocksToString();
    void initAttributes ( ) ;

};

#endif // HIERARCHICALCODEBLOCK_H
