/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Thu Aug 28 2003
 */

#ifndef CPPSOURCECODEDOCUMENT_H
#define CPPSOURCECODEDOCUMENT_H

#include <tqstring.h>

#include "../classifiercodedocument.h"
#include "../hierarchicalcodeblock.h"
#include "classifierinfo.h"

/**
  * class CPPSourceCodeDocument
  * A CPP UMLClassifier Source Code Document.
  */

class CPPSourceCodeDocument : public ClassifierCodeDocument
{
    TQ_OBJECT
  
public:

    // Constructors/Destructors
    //

    /**
     * Constructor
     */
    CPPSourceCodeDocument (UMLClassifier * classifier);

    /**
     * Empty Destructor
     */
    virtual ~CPPSourceCodeDocument ( );

    /** add a code operation to this cpp classifier code document.
     *  @return bool which is true IF the code operation was added successfully
     */
    bool addCodeOperation (CodeOperation * op );

protected:

    // reset/clear our inventory of textblocks in this document
    void resetTextBlocks();

    // a little utility method to save us some work
    TQString getCPPClassName (const TQString &name);

    void updateContent();

private:

    HierarchicalCodeBlock * constructorBlock;
    HierarchicalCodeBlock * methodsBlock;

    void init ( );

};

#endif // CPPSOURCECODEDOCUMENT_H
