/* Synaescope - a pretty noatun visualization (based on P. Harrison's Synaesthesia)
   Copyright (C) 1997 Paul Francis Harrison <pfh@yoyo.cc.monash.edu.au>
                 2001 Charles Samuels <charles@kde.org>

	this file is X11 source
 */

#include "synaescope.h"
#include "cmodule.h"

#include <kdebug.h>
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <kstandarddirs.h>

extern "C"
{
	KDE_EXPORT Plugin* create_plugin()
	{
		TDEGlobal::locale()->insertCatalogue("synaescope");
		return new SynaeScope();
	}
}

SynaeScope::SynaeScope() : Plugin(), scopeExePath(0)
{
	kdDebug(66666) << k_funcinfo << endl;
	restarting=false;
	connect(&process, TQ_SIGNAL(processExited(TDEProcess *)),
		this, TQ_SLOT(processExited(TDEProcess *)));
	connect(&process, TQ_SIGNAL(receivedStdout(TDEProcess *,char *,int)),
		this, TQ_SLOT(receivedStdout(TDEProcess *,char *,int)));
	connect(&process, TQ_SIGNAL(receivedStderr(TDEProcess *,char *,int)),
		this, TQ_SLOT(receivedStderr(TDEProcess *,char *,int)));
}

SynaeScope::~SynaeScope()
{
	kdDebug(66666) << k_funcinfo << endl;
	process.kill();
}

void SynaeScope::init()
{
	kdDebug(66666) << k_funcinfo << endl;
	mPrefs = new SynaePrefs(this);
	mPrefs->reopen();
	mPrefs->save();
	connect(mPrefs, TQ_SIGNAL(configChanged()), this, TQ_SLOT(readConfig()));

	scopeExePath = TDEStandardDirs::findExe("noatunsynaescope.bin");
	if (scopeExePath.isEmpty())
	{
		KMessageBox::error(0, i18n("Unable to locate noatunsynaescope.bin in your path. Check your installation."));
		unload();
	}

	process << scopeExePath;

	runScope();
}

void SynaeScope::runScope()
{
	kdDebug(66666) << k_funcinfo << endl;
	if(!process.start(TDEProcess::NotifyOnExit, (TDEProcess::Communication)(TDEProcess::Stdin | TDEProcess::Stdout)))
	{
		KMessageBox::error(0, i18n("Unable to start noatunsynaescope. Check your installation."));
		unload();
	}
}


void SynaeScope::readConfig()
{
	kdDebug(66666) << k_funcinfo << endl;
	if (!process.isRunning())
		return;

	restarting=true;
	process.kill();
}

void SynaeScope::processExited(TDEProcess *)
{
	kdDebug(66666) << k_funcinfo << endl;
	if(restarting)
	{
		restarting=false;
		runScope();
	}
	else
	{
		unload();
	}
}

void SynaeScope::receivedStdout(TDEProcess *, char *buf, int len)
{
	TQCString debugString(buf,len);
	kdDebug(66666) << k_funcinfo << debugString << endl;
}

void SynaeScope::receivedStderr(TDEProcess *, char *buf, int len)
{
	TQCString debugString(buf,len);
	kdDebug(66666) << k_funcinfo << debugString << endl;
}

#include  "synaescope.moc"
