# Copyright 2023 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_EXTRAGEAR_PACKAGING="yes"
TRINITY_HANDBOOK="never"

TRINITY_LANGS="bg cs pl"

TRINITY_MODULE_TYPE="applications/system"
inherit trinity-base-2

DESCRIPTION="Bluetooth control for TDE"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~x86"
fi

DEPEND="net-wireless/bluez
"
RDEPEND="${DEPEND}"

src_prepare() {
	sed "s|\${SYSCONF_INSTALL_DIR}/dbus-1/system.d|\"/etc/dbus-1/system.d\"|" \
		-i "${S}/CMakeLists.txt" || die
	trinity-base-2_src_prepare
}

src_configure() {
	local mycmakeargs=(
		-DBUILD_TRANSLATIONS=ON
	)
	trinity-base-2_src_configure
}
