# Copyright 1999-2022 Gentoo Authors
# Copyright 2021-2022 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_TYPE="applications/office"

inherit trinity-base-2

DESCRIPTION="TDE internationalization package for Koffice [Trinity]"
HOMEPAGE="http://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~x86"
fi
IUSE=""

TRINITY_LANGS="bg ca cs cy da de el en_GB es et eu fa fi
		fr ga gl hu it ja km lv ms nb nds ne nl pl pt pt_BR
		ru sk sl sr sr@Latn sv tr uk zh_CN zh_TW"

for X in ${TRINITY_LANGS} ; do
	IUSE="${IUSE} l10n_${X}"
done

DEPEND="
	~trinity-base/tdelibs-${PV}
"
RDEPEND="${DEPEND}"

LINGUAS="en"

find_lang() {
	local lang
	lang=${1}
	LINGUAS+=" ${lang}"
}

src_prepare() {
	trinity_l10n_for_each_locale_do find_lang
	trinity-base-2_src_prepare
}

src_configure() {
	local mycmakeargs=( -DBUILD_ALL=ON )
	trinity-base-2_src_configure
}

src_install() {
	[[ "${LINGUAS}" == "en" ]] && return 0
	trinity-base-2_src_install
}
