--- tqt/secqstring.cpp.orig	2017-12-03 16:32:49 UTC
+++ tqt/secqstring.cpp
@@ -80,8 +80,8 @@ static uint computeNewMax( uint len )
 // IMPORTANT! If you change these, make sure you also change the
 // "delete unicode" statement in ~SecTQStringData() in SecTQString.h correspondingly!
 
-#define QT_ALLOC_SECTQCHAR_VEC(N) (TQChar*) ::secmem_malloc (sizeof(TQChar) * (N))
-#define QT_DELETE_SECTQCHAR_VEC(P) ::secmem_free (P)
+#define TQT_ALLOC_SECTQCHAR_VEC(N) (TQChar*) ::secmem_malloc (sizeof(TQChar) * (N))
+#define TQT_DELETE_SECTQCHAR_VEC(P) ::secmem_free (P)
 
 
 /*****************************************************************************
@@ -188,7 +188,7 @@ static uint computeNewMax( uint len )
     \sa TQChar TQCString TQByteArray SecTQConstString
 */
 
-Q_EXPORT SecTQStringData *SecTQString::shared_null = 0;
+TQ_EXPORT SecTQStringData *SecTQString::shared_null = 0;
 QT_STATIC_CONST_IMPL SecTQString SecTQString::null;
 QT_STATIC_CONST_IMPL TQChar TQChar::null;
 QT_STATIC_CONST_IMPL TQChar TQChar::replacement((ushort)0xfffd);
@@ -220,7 +220,7 @@ SecTQStringData* SecTQString::makeSharedNull()
 */
 SecTQString::SecTQString( TQChar ch )
 {
-    d = new SecTQStringData( QT_ALLOC_SECTQCHAR_VEC( 1 ), 1, 1 );
+    d = new SecTQStringData( TQT_ALLOC_SECTQCHAR_VEC( 1 ), 1, 1 );
     d->unicode[0] = ch;
 }
 
@@ -239,7 +239,7 @@ SecTQString::SecTQString( int size, bool /*dummy*/ )
 {
     if ( size ) {
 	int l = size;
-	TQChar* uc = QT_ALLOC_SECTQCHAR_VEC( l );
+	TQChar* uc = TQT_ALLOC_SECTQCHAR_VEC( l );
 	d = new SecTQStringData( uc, 0, l );
     } else {
 	d = shared_null ? shared_null : (shared_null=new SecTQStringData);
@@ -258,7 +258,7 @@ SecTQString::SecTQString( const TQString &str )
 	d = shared_null ? shared_null : makeSharedNull();
 	d->ref();
     } else {
-	TQChar* uc = QT_ALLOC_SECTQCHAR_VEC( length );
+	TQChar* uc = TQT_ALLOC_SECTQCHAR_VEC( length );
 	if ( unicode )
 	    memcpy(uc, unicode, length*sizeof(TQChar));
 	d = new SecTQStringData(uc,unicode ? length : 0,length);
@@ -287,7 +287,7 @@ SecTQString::SecTQString( const TQChar* unicode, uint 
 	d = shared_null ? shared_null : makeSharedNull();
 	d->ref();
     } else {
-	TQChar* uc = QT_ALLOC_SECTQCHAR_VEC( length );
+	TQChar* uc = TQT_ALLOC_SECTQCHAR_VEC( length );
 	if ( unicode )
 	    memcpy(uc, unicode, length*sizeof(TQChar));
 	d = new SecTQStringData(uc,unicode ? length : 0,length);
@@ -429,7 +429,7 @@ void SecTQString::setLength( uint newLen )
 	 ( newLen * 4 < d->maxl && d->maxl > 4 ) ) {
 	// detach, grow or shrink
 	uint newMax = computeNewMax( newLen );
-	TQChar* nd = QT_ALLOC_SECTQCHAR_VEC( newMax );
+	TQChar* nd = TQT_ALLOC_SECTQCHAR_VEC( newMax );
 	if ( nd ) {
 	    uint len = TQMIN( d->len, newLen );
 	    memcpy( nd, d->unicode, sizeof(TQChar) * len );
@@ -594,10 +594,10 @@ SecTQString &SecTQString::insert( uint index, const TQ
 
     if ( s >= d->unicode && (uint)(s - d->unicode) < d->maxl ) {
 	// Part of me - take a copy.
-	TQChar *tmp = QT_ALLOC_SECTQCHAR_VEC( len );
+	TQChar *tmp = TQT_ALLOC_SECTQCHAR_VEC( len );
 	memcpy(tmp,s,len*sizeof(TQChar));
 	insert(index,tmp,len);
-	QT_DELETE_SECTQCHAR_VEC( tmp );
+	TQT_DELETE_SECTQCHAR_VEC( tmp );
 	return *this;
     }
 
@@ -669,10 +669,10 @@ SecTQString &SecTQString::replace( uint index, uint le
 	memcpy( d->unicode+index, s, len * sizeof(TQChar) );
     } else if ( s >= d->unicode && (uint)(s - d->unicode) < d->maxl ) {
 	// Part of me - take a copy.
-	TQChar *tmp = QT_ALLOC_SECTQCHAR_VEC( slen );
+	TQChar *tmp = TQT_ALLOC_SECTQCHAR_VEC( slen );
 	memcpy( tmp, s, slen * sizeof(TQChar) );
 	replace( index, len, tmp, slen );
-	QT_DELETE_SECTQCHAR_VEC( tmp );
+	TQT_DELETE_SECTQCHAR_VEC( tmp );
     } else {
 	remove( index, len );
 	insert( index, s, slen );
