/*

Copyright (C) 2010-2011 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_H
#define TQT_H

#ifndef TQT_VERSION_ONLY

#ifdef TQT_METHOD
#undef TQT_METHOD
#endif
#ifdef TQT_SLOT
#undef TQT_SLOT
#endif
#ifdef TQT_SIGNAL
#undef TQT_SIGNAL
#endif

#ifdef __cplusplus
#define TQT_METHOD(a)	METHOD(a)
#define TQT_SLOT(a)	SLOT(a)
#define TQT_SIGNAL(a)	SIGNAL(a)
#endif /* __cplusplus */


#include <ntqglobal.h>

#ifdef QT_NO_SQL
#define TQT_NO_SQL
#endif /* QT_NO_SQL */

#ifdef Q_WS_X11
#define TQ_WS_X11
#endif /* Q_WS_X11 */

#define Qt TQt

#define tqtr			tr
#define tqaccess		access
#define tqcolorTable		colorTable
#define TQSO_Default		Default
#define SO_Default		Default
#define tqstrcmp		qstrcmp
#define tqt_dynamic_cast	dynamic_cast
#define TQImage_ScaleFree	TQImage::ScaleFree
#define TQIODevice_OpenModeFlag int

#define tqqt_cast		tqt_cast

#define TQAlignCenter AlignCenter
#define TQNoBrush NoBrush

#define tqred red
#define tqgreen green
#define tqblue blue
#define tqcyan cyan
#define tqmagenta magenta
#define tqyellow yellow
#define tqdarkRed darkRed
#define tqdarkGreen darkGreen
#define tqdarkBlue darkBlue
#define tqdarkCyan darkCyan
#define tqdarkMagenta darkMagenta
#define tqdarkYellow darkYellow
#define tqwhite white
#define tqwhiteptr &Qt::white
#define tqlightGray lightGray
#define tqgray gray
#define tqdarkGray darkGray
#define tqblack black
#define tqblackptr &Qt::black
#define tqcolor0 color0
#define tqcolor1 color1

#define IID_TQUnknown IID_QUnknown
#define IID_TQComponentInformation IID_QComponentInformation
#define IID_TQWidgetFactory IID_QWidgetFactory

#define tqmoc	moc
#define TQMOC	MOC

#define WPaintOnScreen	((WFlags)0)

#define TQRGB_MASK	TQT_RGB_MASK

#define tqInstallMsgHandler	qInstallMsgHandler

#define tqdrawPrimitive			drawPrimitive

#define tqsizeFromContents		sizeFromContents

#define QMIN		TQMIN
#define QMAX		TQMAX
#define QABS		TQABS

#define tqMakePair	qMakePair

#define tqt_ucm_query_verification_data	qt_ucm_query_verification_data

#define TQ_ControlElement	ControlElement
#define TQ_ComplexControl	ComplexControl

#define static_TQUType_int	static_QUType_int
#define static_TQUType_TQString	static_QUType_TQString
#define static_TQUType_ptr	static_QUType_ptr
#define static_TQUType_bool	static_QUType_bool
#define static_TQUType_varptr	static_QUType_varptr
#define static_TQUType_charstar	static_QUType_charstar

#define tqreadBlock		readBlock
#define tqwriteBlock		writeBlock
#define TQT_TQIO_LONG		TQ_LONG
#define TQT_TQIO_ULONG		TQ_ULONG

#define TQT_TQOBJECT(x) (static_cast<TQObject*>(static_cast<TQObject*>(x)))
#define TQT_TQWIDGET(x) (static_cast<TQWidget*>(static_cast<TQWidget*>(x)))
#define TQT_TQSIZEPOLICY(x) (static_cast<TQSizePolicy*>(static_cast<TQSizePolicy*>(x)))
#define TQT_TQLAYOUT(x) (static_cast<TQLayout*>(static_cast<TQLayout*>(x)))
#define TQT_TQGRIDLAYOUT(x) (static_cast<TQGridLayout*>(static_cast<TQGridLayout*>(x)))
#define TQT_TQPAINTER(x) (static_cast<TQPainter*>(static_cast<TQPainter*>(x)))
#define TQT_TQPAINTDEVICE(x) (static_cast<TQPaintDevice*>(static_cast<TQPaintDevice*>(x)))
#define TQT_TQLAYOUTITEM(x) (static_cast<TQLayoutItem*>(static_cast<TQLayoutItem*>(x)))
#define TQT_TQIODEVICE(x) (static_cast<TQIODevice*>(static_cast<TQIODevice*>(x)))
#define TQT_TQCOLOR(x) (static_cast<TQColor*>(static_cast<TQColor*>(x)))
#define TQT_TQCHAR(x) TQChar(x)
#define TQT_TQSTRING(x) TQString(x)
#define TQT_TQBUFFER(x) (static_cast<TQBuffer*>(static_cast<TQBuffer*>(x)))
#define TQT_TQWMATRIX(x) (static_cast<TQWMatrix*>(static_cast<TQMatrix*>(x)))
#define TQT_TQFILE(x) (static_cast<TQFile*>(static_cast<TQFile*>(x)))
#define TQT_TQBYTEARRAY(x) (static_cast<TQByteArray*>(static_cast<TQByteArray*>(x)))
#define TQT_TQMIMESOURCE(x) (static_cast<TQMimeSource*>(static_cast<TQMimeSource*>(x)))
#define TQT_TQWEXTRA(x) (static_cast<TQWExtra*>(static_cast<TQWExtra*>(x)))
#define TQT_TQPIXMAP(x) (static_cast<TQPixmap*>(static_cast<TQPixmap*>(x)))
#define TQT_TQCLIPBOARD(x) (static_cast<TQClipboard*>(static_cast<TQClipboard*>(x)))
#define TQT_TQPRINTER(x) (static_cast<TQPrinter*>(static_cast<TQPrinter*>(x)))
#define TQT_TQVARIANT(x) (static_cast<TQVariant*>(static_cast<TQVariant*>(x)))
#define TQT_TQMETAOBJECT(x) (static_cast<TQMetaObject*>(static_cast<TQMetaObject*>(x)))
#define TQT_TQSTYLEOPTION(x) (static_cast<TQStyleOption*>(static_cast<TQStyleOption*>(x)))
#define TQT_TQEVENT(x) (static_cast<TQEvent*>(static_cast<TQEvent*>(x)))
#define TQT_TQKEYEVENT(x) (static_cast<TQKeyEvent*>(static_cast<TQKeyEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQMOVEEVENT(x) (static_cast<TQMoveEvent*>(static_cast<TQMoveEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQSHOWEVENT(x) (static_cast<TQShowEvent*>(static_cast<TQShowEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQMOUSEEVENT(x) (static_cast<TQMouseEvent*>(static_cast<TQMouseEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQWHEELEVENT(x) (static_cast<TQWheelEvent*>(static_cast<TQWheelEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQFOCUSEVENT(x) (static_cast<TQFocusEvent*>(static_cast<TQFocusEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQPAINTEVENT(x) (static_cast<TQPaintEvent*>(static_cast<TQPaintEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQCHILDEVENT(x) (static_cast<TQChildEvent*>(static_cast<TQChildEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQCLOSEEVENT(x) (static_cast<TQCloseEvent*>(static_cast<TQCloseEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQTIMEREVENT(x) (static_cast<TQTimerEvent*>(static_cast<TQTimerEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQRESIZEEVENT(x) (static_cast<TQResizeEvent*>(static_cast<TQResizeEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQTABLETEVENT(x) (static_cast<TQTabletEvent*>(static_cast<TQTabletEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQCONTEXTMENUEVENT(x) (static_cast<TQContextMenuEvent*>(static_cast<TQContextMenuEvent*>(static_cast<TQEvent*>(x))))

#define setTqmaximumSize	setMaximumSize
#define setTqminimumSize	setMinimumSize
#define setTqalignment		setAlignment
#define setTqgeometry		setGeometry

#define tqarrowCursor		Qt::arrowCursor
#define tqupArrowCursor		Qt::upArrowCursor
#define tqcrossCursor		Qt::crossCursor
#define tqwaitCursor		Qt::waitCursor
#define tqibeamCursor		Qt::ibeamCursor
#define tqsizeVerCursor		Qt::sizeVerCursor
#define tqsizeHorCursor		Qt::sizeHorCursor
#define tqsizeBDiagCursor	Qt::sizeBDiagCursor
#define tqsizeFDiagCursor	Qt::sizeFDiagCursor
#define tqsizeAllCursor		Qt::sizeAllCursor
#define tqblankCursor		Qt::blankCursor
#define tqsplitVCursor		Qt::splitVCursor
#define tqsplitHCursor		Qt::splitHCursor
#define tqpointingHandCursor	Qt::pointingHandCursor
#define tqforbiddenCursor	Qt::forbiddenCursor
#define tqwhatsThisCursor	Qt::whatsThisCursor
#define tqbusyCursor		Qt::busyCursor

#define SET_QT_X_TIME(x)	set_tqt_x_time(x)
#define GET_QT_X_TIME(x)	get_tqt_x_time()
#define SET_QT_X_USER_TIME(x)	set_tqt_x_time(x)
#define GET_QT_X_USER_TIME(x)	get_tqt_x_time()

#endif /* TQT_VERSION_ONLY */

#endif /* TQT_H */
