/*
  This file is part of KWeather.
  Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  As a special exception, permission is given to link this program
  with any edition of TQt, and distribute the resulting executable,
  without including the source code for TQt in the source distribution.
*/

#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlayout.h>

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <kcolorbutton.h>
#include <dcopclient.h>
#include <dcopref.h>

#include "dockwidget.h"
#include "serviceconfig.h"

#include "kcmweatherservice.h"
#include "weatherservice_stub.h"

extern "C"
{
	KDE_EXPORT TDECModule *create_weatherservice( TQWidget *parent, const char * )
	{
		return new KCMWeatherService( parent, "kweather" );
	}
}

KCMWeatherService::KCMWeatherService( TQWidget *parent, const char *name )
	: TDECModule( parent, name )
{
	mWeatherService = new WeatherService_stub( "KWeatherService",
																						 "WeatherService" );
	TQVBoxLayout *layout = new TQVBoxLayout( this );
	mWidget = new serviceConfig( this );

	layout->addWidget( mWidget );
	layout->addStretch();

	load();
	connect( mWidget->m_enableLog, TQT_SIGNAL( toggled( bool ) ),
					 TQT_SLOT( enableLogWidgets( bool ) ) );
	connect( mWidget->m_iconTheme, TQT_SIGNAL( released( int ) ),
					 TQT_SLOT( changed() ) );

	TDEAboutData *about = new TDEAboutData(
		I18N_NOOP( "kcmweatherservice" ),
		I18N_NOOP( "KWeather Configure Dialog" ),
		0, 0, TDEAboutData::License_GPL,
		I18N_NOOP( "(c), 2003 Tobias Koenig" ) );

	about->addAuthor( "Tobias Koenig", 0, "tokoe@kde.org" );
	setAboutData(about);
}

KCMWeatherService::~KCMWeatherService()
{
	delete mWeatherService;
}

void KCMWeatherService::enableLogWidgets( bool value )
{
	mWidget->m_logFile->setEnabled( value );
	mWidget->m_labelLogFile->setEnabled( value );

	emit changed( true );
}

void KCMWeatherService::load()
{
	kdDebug() << "Load" << endl;
	TDEConfig config( "weather_panelappletrc" );

	config.setGroup( "General Options" );
	bool enabled = config.readBoolEntry( "logging", false );
	mWidget->m_enableLog->setChecked( enabled );
	enableLogWidgets( enabled );

	mWidget->m_logFile->setURL( config.readPathEntry( "log_file_name" ) );

	mUseIconTheme = config.readBoolEntry("use_icon_theme", true);
	mWidget->m_iconTheme->setButton( mUseIconTheme ? 0 : 1 );

	emit changed( false );
}

void KCMWeatherService::save()
{
	kdDebug() << "Save" << endl;
	TDEConfig config( "weather_panelappletrc" );

	config.setGroup( "General Options" );
	config.writeEntry( "logging", mWidget->m_enableLog->isChecked() );
	config.writeEntry( "log_file_name", mWidget->m_logFile->url() );

	mUseIconTheme = (mWidget->m_iconTheme->selectedId() == 0);
	config.writeEntry( "use_icon_theme", mUseIconTheme );
	updateIconTheme(mUseIconTheme);

	config.sync();

	emit changed( false );
}

void KCMWeatherService::defaults()
{
	mWidget->m_enableLog->setChecked( false );
	enableLogWidgets( false );
	mWidget->m_logFile->setURL( "" );

	mWidget->m_iconTheme->setButton(0);

	emit changed( true );
}

void KCMWeatherService::updateIconTheme( bool useIconTheme )
{
	DCOPRef ws( "KWeatherService", "WeatherService" );
	DCOPReply reply = ws.call( "useIconTheme", useIconTheme );
	if( ! reply.isValid() )
	{
		kdDebug(12004) << "[kcmweatherservice::updateIconTheme] DCOP call failed" << endl;
	}
}

#include "kcmweatherservice.moc"
