/***************************************************************************
                          navview.cpp  -  description
                             -------------------
    begin                : Tue May 1 2001
    copyright            : (C) 2001 by Richard Moore
    email                : rich@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqobjectlist.h>
#include <tqobjectdict.h>

#include <tdelocale.h>

#include "navview.h"
#include "navviewitem.h"

NavView::NavView(TQWidget *parent, const char *name ) : TDEListView(parent,name)
{
  addColumn( i18n( "Name" ) );
  addColumn( i18n( "Type" ) );

  setRootIsDecorated( true );
  setAllColumnsShowFocus( true );
  setFullWidth( true );

  connect( this, TQT_SIGNAL( selectionChanged( TQListViewItem * ) ),
           this, TQT_SLOT( selectItem( TQListViewItem * ) ) );
}

NavView::~NavView(){
}

void NavView::buildTree()
{
  const TQObjectList *roots = TQObject::objectTrees();
  TQObjectListIt it( *roots );

  TQObject * obj;
  while ( (obj = it.current()) != 0 ) {
    ++it;
    NavViewItem *item = new NavViewItem( this, obj );
    createSubTree( item );
  }
}

void NavView::expandVisibleTree()
{
  TQListViewItemIterator it( this, TQListViewItemIterator::Visible |
                                  TQListViewItemIterator::Expandable );

  while ( it.current() ) {
    setOpen( *it, true );
    ++it;
  }
}

void NavView::selectItem( TQListViewItem *item )
{
  NavViewItem *navItem = static_cast<NavViewItem*>( item );

  emit selected( navItem->data );
}

void NavView::createSubTree( NavViewItem *parent )
{
  const TQObjectList kids = parent->data->childrenListObject();
  if ( kids.isEmpty() )
    return;

  TQObject * obj;
  TQObjectListIt it( kids );
  while ( (obj=it.current()) != 0 ) {
    ++it;
    NavViewItem *item = new NavViewItem( parent, obj );
    createSubTree( item );
  }
}

#include "navview.moc"
