/**********************************************************************

 $$Id$$

 Dock Server Controller.  Displays server connection window, and makes
 new server connection on demand.

 *********************************************************************/

#include "dockservercontroller.h"

#include <tqpopupmenu.h>
#include <tqwidget.h>
#include <tqapplication.h>
#include <tqregexp.h>
#include <tqtimer.h>
#include <tqcursor.h>
#include <kpassivepopup.h>
#include <tdepopupmenu.h>
#include <tdelocale.h>
#include <tdeaction.h>
#include <twin.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <kpassivepopup.h>
#include <tdemessagebox.h>
#include <kglobalaccel.h>
#include <kkeydialog.h>
#include <tdeversion.h>

#include "KSPrefs/ksprefs.h"

#include "servercontroller.h"
#include "toplevel.h"
#include "ksopts.h"

#include "objFinder.h"
#include "displayMgr.h"
#include "objFinder.h"

#include "dccNew.h"

extern DisplayMgr *displayMgr;

dscNickInfo::dscNickInfo(TQString nick, TQString server) :
    m_nick(nick),
    m_server(server)
{
}

dscNickInfo::~dscNickInfo()
{
}


dockServerController::dockServerController(servercontroller *sc, TQWidget *parent, const char *_name)
: KSystemTray(parent, _name),
  m_sc(sc)
{

  m_nicks.setAutoDelete(true);
  TDEPopupMenu *pop = contextMenu();
  pop->setName("dockServerController_menu_pop");

#ifndef NDEBUG
  pop->insertItem(i18n("Dump Object Tree"), sc, TQT_SLOT(dump_obj()));
  pop->insertItem(i18n("Server Debug Window"), sc, TQT_SLOT(server_debug()));
  pop->insertSeparator();
#endif


  pop->insertItem(SmallIcon( "filter" ), i18n("&Filter Rule Editor..."),
                  m_sc, TQT_SLOT(filter_rule_editor()));

  KStdAction::preferences(TQT_TQOBJECT(m_sc), TQT_SLOT(general_prefs()),
                  m_sc->actionCollection())->plug(pop);
  KStdAction::configureNotifications(TQT_TQOBJECT(m_sc), TQT_SLOT(notification_prefs()), actionCollection())->plug(pop);

  pop->insertSeparator();
  pop->insertItem(i18n("New &Server..."),
		  m_sc, TQT_SLOT(new_connection()));
  pop->insertItem(i18n("&Do Autoconnect..."), m_sc, TQT_SLOT(start_autoconnect_check()));
  connect(this, TQT_SIGNAL(quitSelected()), m_sc, TQT_SLOT(endksirc()));

#if KDE_IS_VERSION(3,1,92)
  m_pic_dock = KSystemTray::loadIcon( "ksirc" );
#else
  m_pic_dock = UserIcon("ksirc_dock");
#endif
  m_pic_info = UserIcon("application-vnd.tde.info");

  if ( !m_pic_dock.isNull() )
      setPixmap( m_pic_dock );

  mainPop = 0x0;
  m_mainPopVisible = false;
  createMainPopup();

  m_blinkTimer = new TQTimer( this );
  connect( m_blinkTimer, TQT_SIGNAL(timeout()), this, TQT_SLOT( blinkDockedIcon() ) );
  m_blinkStatus = false;
  m_blinkActive = false;

  servercontroller::self()
      ->getGlobalAccel()
      ->insert("Raise Last Window", i18n("Raise Last Window"),
		i18n("If someone said your nick in a window, this action "
                     "will make that window active for you."),
	       ALT+CTRL+Key_A, KKey::QtWIN+CTRL+Key_A, TQT_TQOBJECT(this),
	       TQT_SLOT(raiseLastActiveWindow()));
  servercontroller::self()
      ->getGlobalAccel()
      ->insert("Clear Blink", i18n("Clear Blinking Dock Icon"),
		i18n("If the dock icon is blinking, but you don't want "
		     "to go to the window this will clear the blinking."),
	       ALT+CTRL+Key_Down, KKey::QtWIN+CTRL+Key_Down, TQT_TQOBJECT(this),
	       TQT_SLOT(blinkClear()));

//  mainPop = new TDEPopupMenu(this, "dockServerController_main_pop");
//  mainPop->setTitle(i18n("KSirc Dock Menu"));

}



dockServerController::~dockServerController()
{
kdDebug(5008) << "~dockServerController in" << endl;
    m_sc = 0x0;
kdDebug(5008) << "~dockServerController out" << endl;
}

int dockServerController::intoPopupSorted(TQString str, TQPopupMenu *what)
{
    uint i = 0;

    for(i = 0; i < mainPop->count(); i++){
	if(mainPop->text(mainPop->idAt(i)) > str){
	    break;
	}
    }
    return mainPop->insertItem(str, what, -1, i);

}

void dockServerController::mainPopShow()
{
    m_mainPopVisible = true;
}

void dockServerController::mainPopHide()
{
    m_mainPopVisible = false;
}

void dockServerController::createMainPopup()
{
    if(m_mainPopVisible == true)
	return;

    if(mainPop)
	delete mainPop;
    mainPop = new TDEPopupMenu(this, "dockservercontrller_main_pop");
    connect(mainPop, TQT_SIGNAL(activated(int)),
	    this, TQT_SLOT(mainActivated(int)));
    connect(mainPop, TQT_SIGNAL(aboutToShow()),
	    this, TQT_SLOT(mainPopShow()));
    connect(mainPop, TQT_SIGNAL(aboutToHide()),
	    this, TQT_SLOT(mainPopHide()));


    TQDictIterator<dscNickInfo> it( m_nicks );
    for( ; it.current(); ++it){
	TDEPopupMenu *sub = new TDEPopupMenu(mainPop);
	if(it.current()->status() == dscNickInfo::isOnline){
	    sub->insertItem(i18n("Came Online: ") + it.current()->online().toString("hh:mm"));
	    if( ! it.current()->offline().isNull() ){
		sub->insertItem(i18n("Last Offline: ") + it.current()->offline().toString("hh:mm"));
	    }
	    int pid = sub->insertItem(i18n("Ping"));
	    int wid = sub->insertItem(i18n("Whois"));
	    int cid = sub->insertItem(i18n("Chat"));
	    int dcid = sub->insertItem(i18n("DCC Chat"));

	    int id = intoPopupSorted(it.current()->server() +" -> " + it.current()->nick() + " " + i18n("online"), sub);
	    sub->setItemParameter(pid, id);
	    sub->setItemParameter(cid, id);
	    sub->setItemParameter(wid, id);
	    sub->setItemParameter(dcid, id);
	    connect(sub, TQT_SIGNAL(activated(int)),
                    this, TQT_SLOT(subItemActivated(int)));
	}
	else {
	    sub->insertItem(i18n("Went Offline: ") + it.current()->offline().toString("hh:mm"));
	    if( ! it.current()->online().isNull() ){
		sub->insertItem(i18n("Last Online: ") + it.current()->online().toString("hh:mm"));
	    }

	    intoPopupSorted(it.current()->server() +" -> " + it.current()->nick() + i18n(" offline"), sub);
	}
    }
    if(m_blink_reason.count() > 0){
        mainPop->insertSeparator();
        for ( TQStringList::Iterator it = m_blink_reason.begin(); it != m_blink_reason.end(); ++it ) {
            mainPop->insertItem(*it);
        }
    }
    if(mainPop->count() == 0){
        mainPop->insertItem(i18n("Help on Notify Popup..."), this, TQT_SLOT(helpNotice()));
	mainPop->insertItem(i18n("Configure Notify..."), this, TQT_SLOT(configNotify()));
    }
}

void dockServerController::subItemActivated(int sub_id)
{
    const TQPopupMenu *sub = dynamic_cast<const TQPopupMenu *>(sender());
    if(!sub){
        kdDebug(5008) << "subItemActivated by non TQPopupMenu" << endl;
        return;
    }
    int main_id = sub->itemParameter(sub_id);
    TQString mainText = mainPop->text(main_id);
    if(mainText.isNull()){
        kdDebug(5008) << "failed to get mainPop text" << endl;
    }
    TQRegExp rx("(\\S+) -> (\\S+) ");
    if(rx.search(mainText) >= 0){
	TQString mserver = rx.cap(1);
	TQString mnick = rx.cap(2);

	TQString ns = mserver + "/" + mnick;

	if(m_nicks[ns]){
            kdDebug(5008) << "Got " << sub->text(sub_id) << " request for " << ns << endl;
            TQString cmd = sub->text(sub_id);
            TQString server = m_nicks[ns]->server();
            TQString nick = m_nicks[ns]->nick();

	    if(cmd == i18n("Chat")){
                servercontroller::self()->new_toplevel(KSircChannel(server, nick));
            }
	    else {
                KSircProcess *kp = servercontroller::self()->processes().find(server);
                if(kp){
                    KSircTopLevel *wm = dynamic_cast<KSircTopLevel *>(kp->getWindowList().find("!default"));
		    if(wm){
			if(cmd == i18n("Ping")){
			    wm->sirc_line_return("/ping " + nick + "\n");
			} else if(cmd == i18n("Whois")){
			    wm->sirc_line_return("/whois " + nick + "\n");
			} else if(cmd == i18n("DCC Chat")){
			    wm->sirc_line_return("/dcc chat " + nick + "\n");
			}
                    }
                }
            }
	}
    }

}

void dockServerController::mousePressEvent( TQMouseEvent *e )
{
    if(e->button() == Qt::LeftButton){
	showPopupMenu(mainPop);
    }
    else {
	KSystemTray::mousePressEvent(e);
    }
}

void dockServerController::showPopupMenu( TQPopupMenu *menu )
{
    Q_ASSERT( menu != 0L );

    menu->popup(TQCursor::pos());

}

void dockServerController::nickOnline(TQString server, TQString nick)
{
    TQString sn = server + "/" + nick;
    if(!m_nicks[sn])
        m_nicks.insert(sn, new dscNickInfo(nick, server));
    m_nicks[sn]->setOnline();
    createMainPopup();
}

void dockServerController::nickOffline(TQString server, TQString nick)
{
    TQString sn = server + "/" + nick;
    if(!m_nicks[sn])
	m_nicks.insert(sn, new dscNickInfo(nick, server));
    m_nicks[sn]->setOffline();
    createMainPopup();
}

void dockServerController::serverOpen(TQString)
{
}

void dockServerController::serverClose(TQString server)
{
    TQDictIterator<dscNickInfo> it( m_nicks );
    while(it.current()){
	if(it.current()->server() == server)
	    m_nicks.remove(it.currentKey());
	else
            ++it;
    }
    createMainPopup();
}

void dockServerController::startBlink(const TQString& reason, const TQString& text)
{
    if(m_blinkActive == false){
        // change icon (to "someone's talking to you" icon)
        setPixmap( m_pic_info );
        m_blinkStatus = true;
        m_blinkActive = true;
	m_blinkTimer->start( 500 ); // half a second
    }
    if(!reason.isNull()){
        TQString br(reason);
        if(text.isNull() && ksopts->runDocked && ksopts->dockPopups)
	    KPassivePopup::message(TQString("Notify: %1").arg(reason), this);
	else {
	    TQStringList sl;
	    TQString cutup = text;
	    int i = 0;
	    br = reason + " " + text.left(50);
	    if(text.length() > 50)
                br.append("...");
	    while(!cutup.isEmpty() && i++ < 3){
		sl.append(cutup.left(50));
                cutup.remove(0, 50);
	    }
	    cutup = sl.join("\n");
	    cutup.truncate(cutup.length()-1);
	    if(ksopts->runDocked && ksopts->dockPopups)
		KPassivePopup::message(TQString("%1").arg(reason), cutup, this);
	}
	m_blink_reason.append(br);
	createMainPopup();
	kdDebug(5008) << "Blink reason: " << br << endl;

	TQRegExp rx("(\\S+) -> (\\S+)");
	if(rx.search(reason) >= 0){
	    TQString server = rx.cap(1);
	    TQString nick = rx.cap(2);

	    m_last_server = server;
	    m_last_nick = nick;
	}
    }
}

void dockServerController::stopBlink(const TQString& reason, bool clear)
{
    if(clear == true){
        m_blinkActive = false;
        m_blinkTimer->stop();
        setPixmap( m_pic_dock );
        m_blink_reason.clear();
    }
    else {
        if(!reason.isNull())
            m_blink_reason.remove(reason);
    }
    createMainPopup();
}

void dockServerController::blinkClear()
{
    m_sc->resetNotification();
}

void dockServerController::mainActivated(int id)
{
    TQRegExp rx("(\\S+) -> (\\S+) ");
    if(rx.search(mainPop->text(id)) >= 0){
        TQString server = rx.cap(1);
        TQString nick = rx.cap(2);

        raiseWindow(server, nick);

    }
}

void dockServerController::raiseLastActiveWindow()
{
    if((!m_last_server.isNull()) && (!m_last_nick.isNull()))
        raiseWindow(m_last_server, m_last_nick);
}

void dockServerController::blinkDockedIcon()
{
    m_blinkStatus = !m_blinkStatus;
    setPixmap( m_blinkStatus ? m_pic_info : m_pic_dock );
}

void dockServerController::helpNotice()
{
    KMessageBox::information(0x0,
			     i18n("This popup menu can show a list of "
				  "people you have in your notify "
				  "list, and their status. You can configure "
				  "this list by going to Configure KSirc->"
				  "Startup->Notify and adding people to the "
				  "list. This will take effect the next "
				  "time you connect to a server. "
				  "This message appears when "
				  "there is nothing in your notify "
				  "list or when no one in your "
				  "list is online."
				 ),
			     i18n("Help for Notification Popup"));

}

void dockServerController::configNotify()
{
    KSPrefs *kp = new KSPrefs();
    connect(kp, TQT_SIGNAL(update(int)),
	    m_sc, TQT_SLOT(configChange()));
    kp->resize(550, 450);
    kp->showPage(2); /* Show auto connect page */
    kp->show();

}


void dockServerController::raiseWindow(TQString server, TQString name)
{
    TQCString txt = server.utf8() + "_" + name.utf8() + "_toplevel";
    TQWidget *obj = dynamic_cast<TQWidget *>( objFinder::find(txt, "KSircTopLevel"));
    if(obj == 0x0){
	txt = server.utf8() + "_!" + name.utf8() + "_toplevel";
	obj = dynamic_cast<TQWidget *>( objFinder::find(txt, "KSircTopLevel"));
    }

    if(obj != 0x0){
	displayMgr->raise(obj, true);
    }
    else {
	kdWarning() << "Did not find widget ptr to raise it" << endl;
    }
}

#include "dockservercontroller.moc"

