/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel   *
 *   the_docter@gmx.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MENULISTVIEWITEM_H
#define MENULISTVIEWITEM_H

#include <tqlistview.h>
#include <kdemacros.h>

class KDE_EXPORT MenuListViewItem : public TQListViewItem
{
    public:
        enum ItemType{Menu,Button};

        //The after parameter is needed to avoid, that the Buttons get reversed everytime the config file is loaded
        MenuListViewItem(TQListViewItem* parent, TQListViewItem* after, TQString col1, ItemType type=Button, TQString iconPath=NULL, TQString col2=NULL);
        MenuListViewItem(TQListView* parent, TQListViewItem* after, TQString col1, ItemType type=Button, TQString iconPath=NULL, TQString col2=NULL);

        ~MenuListViewItem();

        void setType(const ItemType icontype){ mType = icontype; }
        ItemType type() const{ return mType; }

        void setIconPath(const TQString& path);
        MenuListViewItem* lastChild();
        TQString iconPath() const { return mIconPath; }

    protected:
        ItemType mType;
        TQString mIconPath;
};

#endif
