/****************************************************************************
**
** Definition of TQt3CairoPaintDevice class
**
** Copyright (C) 2012 Timothy Pearson.  All rights reserved.
**
** This file is part of the TDE GTK3 style interface
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

#ifndef TQTCAIROPAINTER_H
#define TQTCAIROPAINTER_H

#include "tqpaintdevice.h"
#include "tqbuffer.h"
#include "tqcolor.h"
#include "tqpen.h"
#include "tqbrush.h"
#include "tqfont.h"
#include "tqimage.h"
#include "tqptrstack.h"
#include "tqpainter.h"

#include <cairo.h>
#include <pango/pangocairo.h>

typedef TQPtrStack<TQWMatrix> TQWMatrixStack;

class KPixmapIO;

class TQ_EXPORT TQt3CairoPaintDevice : public TQPaintDevice		// picture class
{
	public:
		TQt3CairoPaintDevice( cairo_surface_t *, int x = 0, int y = 0, int width = -1, int height = -1, cairo_t *overridepainter = NULL );
		~TQt3CairoPaintDevice();

	protected:
		bool cmd( int, TQPainter *, TQPDevCmdParam * );
		int metric( int ) const;

	private:
		void init();
		void updateSurfaceDimensions() const;
		void resetIntermediateSurface();
		void transferIntermediateSurface();
		bool intermediateSurfaceInUse() const;

		void updatePen(bool backgroundStroke=FALSE);
		void dualStrokePen();

		void updateBrush(bool backgroundStroke=FALSE, cairo_fill_rule_t fillMethod=CAIRO_FILL_RULE_WINDING);
		void dualStrokeBrush(cairo_fill_rule_t fillMethod=CAIRO_FILL_RULE_WINDING);

		void drawPolygon(const TQPointArray* pointarray, bool winding, bool fill, bool close);
		void drawRoundRect(int x, int y, int w, int h, int xRnd, int yRnd);
		void drawEllipse(int x, int y, int w, int h);
		void drawArc(int x, int y, int w, int h, int a, int alen);
		void drawPie(int x, int y, int w, int h, int a, int alen);
		void drawChord(int x, int y, int w, int h, int a, int alen);

		void pangoSetupTextPath(PangoLayout *layout, const char* text);
		void drawText(TQPainter *p, int x, int y, const TQString &str);
		void drawTextInRect(TQPainter *p, TQRect rect, int textFlags, const TQString &str);

		void setCairoTransformations(cairo_t* cr, bool forceDisable=false, bool applyBaseDeviceTransform=false);

	private:
		mutable int m_width;
		mutable int m_height;
		mutable int m_offsetX;
		mutable int m_offsetY;

		cairo_surface_t *m_surface;
		cairo_surface_t *m_intermediateSurface;
		cairo_t *m_painter;
		cairo_t *m_devicePainter;
		cairo_t *m_overridePainter;
		cairo_matrix_t m_deviceMatrix;
		cairo_matrix_t m_worldMatrix;
		cairo_matrix_t m_viewportMatrix;
		bool m_worldMatrixEnabled;
		bool m_viewportMatrixEnabled;

		TQColor m_bgColor;
		TQt::BGMode m_bgColorMode;
		TQPen m_pen;
		TQBrush m_brush;
		TQPoint m_brushOrigin;
		TQFont m_font;
		TQt::RasterOp m_rop;
		TQImage m_clipRegion;
		bool m_clipRegionEnabled;
		TQWMatrixStack m_worldMatrixStack;

		PangoTabArray* m_tabStops;
		PangoTabArray* m_tabStopArray;
		bool m_tabStopsValid;
		bool m_tabStopArrayValid;

		bool m_transferNeeded;
		KPixmapIO* tdePixmapIO;
};

#endif // TQTCAIROPAINTER_H
