/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "regexps.h"

#include <kdebug.h>

bool match_dversion(TQString version)
{
  static TQRegExp rx_revision(rxs_revision);
  TQString allowed_vchars = ".+\\w";

  kdDebug(7130) << version << endl;
  if (version[1] == ':')
  {
    allowed_vchars += ":";
    if (! version[0].isDigit()) return false;
    kdDebug(7130) << "Matched epoch" << endl;
    version = version.right( version.length() - 2 );
  }

  kdDebug(7130) << version << endl;
  int rev_pos = version.findRev('-');
  if (rev_pos > -1)
  {
    allowed_vchars += "-";
    TQString revision = version.right( version.length() - rev_pos - 1);
    if (! rx_revision.exactMatch(revision))
      return false;

    kdDebug(7130) << "Matched revision" << endl;
    version.truncate( version.length() - rev_pos - 1 );
  }

  TQRegExp rx_version("\\d[" + allowed_vchars + "]*");
  return rx_version.exactMatch(version);
}
