/***************************************************************************
 *     Copyright (C) 2004 by Sashmit Bhaduri                               *
 *     smt@vfemail.net                                                     *
 *                                                                         *
 *     Licensed under GPL.                                                 *
 ***************************************************************************/

#include "tabwidget.h"

#include <tqstyle.h>
#include <tqclipboard.h>
#include <tqstringlist.h>

#include <tdeapplication.h>
#include <ktabbar.h>
#include <tdepopupmenu.h>
#include <tdelocale.h>
#include <kiconloader.h>

using namespace KlamAV;

TabWidget::TabWidget(TQWidget * parent, const char *name, TQStringList fixed)
        :KTabWidget(parent, name), m_CurrentMaxLength(30)
{
    fixedTabs = TQStringList(fixed);
    setTabReorderingEnabled(true);
    connect( this, SIGNAL( currentChanged(TQWidget *) ), this,
            SLOT( slotTabChanged(TQWidget *) ) );
    connect(this, SIGNAL(closeRequest(TQWidget*)), this, SLOT(slotCloseRequest(TQWidget*)));
    //setHoverCloseButton(Settings::closeButtonOnTabs());
}

TabWidget::~TabWidget()
{
}

void TabWidget::slotSettingsChanged()
{
    //if (hoverCloseButton() != Settings::closeButtonOnTabs())
    //    setHoverCloseButton(Settings::closeButtonOnTabs());
}

void TabWidget::addFrame(Frame *f)
{
    if (!f || !f->widget()) return;
    m_frames.insert(f->widget(), f);
    addTab(f->widget(), f->title());
}

Frame *TabWidget::currentFrame()
{
    TQWidget *w=currentPage();
    if (!w) return 0;
    return m_frames[w];
}

void TabWidget::slotTabChanged(TQWidget *w)
{
    emit currentFrameChanged(m_frames[w]);
}

void TabWidget::removeFrame(Frame *f)
{
    f->setCompleted();
    m_frames.remove(f->widget());
    removePage(f->widget());
    setTitle( currentFrame()->title(), currentPage() );
}

// copied wholesale from KonqFrameTabs
unsigned int TabWidget::tabBarWidthForMaxChars( uint maxLength )
{
    int hframe, overlap;
    hframe    = tabBar()->style().pixelMetric( TQStyle::PM_TabBarTabHSpace, this );
    overlap = tabBar()->style().pixelMetric( TQStyle::PM_TabBarTabOverlap, this );

    TQFontMetrics fm = tabBar()->fontMetrics();
    int x = 0;
    for( int i=0; i < count(); ++i ) {
        Frame *f=m_frames[page(i)];
        TQString newTitle=f->title();
        if ( newTitle.length() > maxLength )
            newTitle = newTitle.left( maxLength-3 ) + "...";

        TQTab* tab = tabBar()->tabAt( i );
        int lw = fm.width( newTitle );
        int iw = 0;
        if ( tab->iconSet() )
            iw = tab->iconSet()->pixmap( TQIconSet::Small, TQIconSet::Normal ).width() + 4;

        x += ( tabBar()->style().sizeFromContents( TQStyle::CT_TabBarTab, this,                             TQSize( TQMAX( lw + hframe + iw, TQApplication::globalStrut().width() ), 0 ), TQStyleOption( tab ) ) ).width();
    }
    return x;
}

void TabWidget::setTitle( const TQString &title , TQWidget* sender)
{
    removeTabToolTip( sender );

    Frame *f=m_frames[sender];
    if (f)
        f->setTitle(title);

    uint lcw=0, rcw=0;
    int tabBarHeight = tabBar()->sizeHint().height();
    if ( cornerWidget( TopLeft ) && cornerWidget( TopLeft )->isVisible() )
        lcw = TQMAX( cornerWidget( TopLeft )->width(), tabBarHeight );
    if ( cornerWidget( TopRight ) && cornerWidget( TopRight )->isVisible() )
        rcw = TQMAX( cornerWidget( TopRight )->width(), tabBarHeight );
    uint maxTabBarWidth = width() - lcw - rcw;

    uint newMaxLength=30;
    for ( ; newMaxLength > 3; newMaxLength-- ) {
        if ( tabBarWidthForMaxChars( newMaxLength ) < maxTabBarWidth )
            break;
    }
    TQString newTitle = title;
    if ( newTitle.length() > newMaxLength )
    {
        setTabToolTip( sender, newTitle );
        newTitle = newTitle.left( newMaxLength-3 ) + "...";
    }

    newTitle.replace( '&', "&&" );
    if ( tabLabel( sender ) != newTitle )
        changeTab( sender, newTitle );

    if( newMaxLength != m_CurrentMaxLength )
    {
        for( int i = 0; i < count(); ++i)
        {
            Frame *f=m_frames[page(i)];
            newTitle=f->title();
            removeTabToolTip( page( i ) );
            if ( newTitle.length() > newMaxLength )
            {
                setTabToolTip( page( i ), newTitle );
                newTitle = newTitle.left( newMaxLength-3 ) + "...";
            }

            newTitle.replace( '&', "&&" );
            if ( newTitle != tabLabel( page( i ) ) )
                    changeTab( page( i ), newTitle );
        }
        m_CurrentMaxLength = newMaxLength;
    }
}

void TabWidget::contextMenu(int i, const TQPoint &p)
{
   currentItemId = i;
   currentItem = page(i);
   TDEPopupMenu popup;

   int moveTabLeft = popup.insertItem( SmallIcon("back"), i18n("Move Tab &Left"), this, SLOT(slotMoveTabLeft()) );
   int moveTabRight = popup.insertItem( SmallIcon("forward"), i18n("Move Tab &Right"), this, SLOT(slotMoveTabRight()) );
   popup.insertSeparator();
   int closeTab = popup.insertItem( SmallIcon("tab_remove"), i18n("Close Tab"), this, SLOT(slotCloseTab()) );

   if(currentItemId == 0)
      popup.setItemEnabled(moveTabLeft, false);

   if(currentItemId == count() - 1)
      popup.setItemEnabled(moveTabRight, false);

   for( TQStringList::Iterator it = fixedTabs.begin(); it != fixedTabs.end(); ++it) {
    if( TQString(*it) == label(currentItemId).replace('&',TQString::null)  )
      popup.setItemEnabled(closeTab, false);
   }

   popup.exec(p);
}


void TabWidget::slotMoveTabLeft() {
  if( currentItemId > 0 )
    moveTab(currentItemId, currentItemId-1);
}

void TabWidget::slotMoveTabRight() {
  if( currentItemId < count() - 1 )
    moveTab(currentItemId, currentItemId+1);
}

void TabWidget::slotCloseTab()
{
   if(!currentItem) return;
   removePage(currentItem);
   emit tabClosed( currentItem->name() );
   currentItem = 0;
}

void TabWidget::slotCloseRequest(TQWidget* widget)
{
    if (m_frames.find(widget) != NULL)
        removeFrame(m_frames.find(widget));
}

#include "tabwidget.moc"
