#################################################
#
#  (C) 2011 Timothy Pearson
#  kb9vqf (AT) pearsoncomputing.net
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################


# required stuff

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

find_package( TQt )
find_package( TDE )


##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( systems.h HAVE_SYSTEMS_H )
check_include_file( linux/inotify.h HAVE_INOTIFY )

check_function_exists( statvfs HAVE_STATVFS )


#### Find strigi if needed #######################

IF (USE_STRIGI)
	FIND_PACKAGE(Strigi REQUIRED)
	INCLUDE_DIRECTORIES(${STRIGI_INCLUDE_DIR})
	MESSAGE(STATUS "Strigi support is: ON!")
ELSE (USE_STRIGI)
	MESSAGE(STATUS "Strigi support is: OFF!")
ENDIF (USE_STRIGI)


#### Find menudrake if needed #####################

FIND_PROGRAM(HAVE_MANDRAKE menudrake)
IF (HAVE_MANDRAKE AND USE_MENUDRAKE)
	SET(MANDRAKE "1")
	MESSAGE(STATUS "Will use 'menudrake' instead of 'kmenuedit'!")
ELSE (HAVE_MANDRAKE AND USE_MENUDRAKE)
	SET(MANDRAKE "")
	MESSAGE(STATUS "Will use 'kmenuedit'!")
ENDIF (HAVE_MANDRAKE AND USE_MENUDRAKE)
