/***************************************************************************
                          kbswitchintf.h  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBSWITCHINTF_H
#define KBSWITCHINTF_H

#include <dcopobject.h>
#include <ntqobject.h>
#include <ntqstringlist.h>

#include "kbconfig.h"

/**This class implements DCOP bindings for KBSwitch
  *@author Leonid Zeitlin
  */

/* Interesting to note: moc failed on this file when the k_dcop section immediately
   followed the signals section (the error message was "syntax error"). After I
   separated the signals and k_dcop sections with the public section everything worked.
   Apparently, the k_dcop "keyword" confuses moc, which is only natural given that
   moc doesn't know about dcopidl! */
class KBSwitchIntf : public TQObject, public DCOPObject  {
  K_DCOP
  TQ_OBJECT
signals:
  void nextGroupSelected();	
  void groupSelected(int groupno);
public:
	KBSwitchIntf(TQObject *parent, KBConfig *conf);
	~KBSwitchIntf();
private:
	KBConfig *m_kbconf;
k_dcop:
  int getNumKbdGroups();
  ASYNC selectNextGroup();
  ASYNC selectGroup(int groupno);
  TQStringList getGroupNames();
};

#endif
