/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "kivio_icon_view.h"

#include "kivio_stencil_spawner.h"
#include "kivio_stencil_spawner_set.h"
#include "kivio_stencil_spawner_info.h"
#include "kivio_spawner_drag.h"
#include "kivio_common.h"
#include "kivioglobal.h"
#include "kivio_stencil.h"

#include <tqbrush.h>
#include <tqcursor.h>
#include <tqpalette.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tdeglobalsettings.h>

KivioStencilSpawner* KivioIconView::m_pCurDrag = 0L;
TQPtrList<KivioIconView> KivioIconView::objList;

/**********************************************************************
 *
 * KivioIconViewItem
 *
 **********************************************************************/
KivioIconViewItem::KivioIconViewItem( TQIconView *parent )
    : TQIconViewItem( parent )
{
    m_pSpawner = NULL;
    setText("stencil");
}

KivioIconViewItem::~KivioIconViewItem()
{
    m_pSpawner = NULL;
}

void KivioIconViewItem::setStencilSpawner( KivioStencilSpawner *pSpawn )
{
    KivioStencilSpawnerInfo *pInfo;

    m_pSpawner = pSpawn;

    if( !m_pSpawner )
    {
        setText( i18n("untitled stencil", "Untitled") );
    }
    else
    {
        pInfo = m_pSpawner->info();
        setText( pInfo->title() );
        KivioStencil* stencil = m_pSpawner->newStencil();
        setPixmap(Kivio::generatePixmapFromStencil(32, 32, stencil));
        delete stencil;
    }

}

bool KivioIconViewItem::acceptDrop( const TQMimeSource * ) const
{
    return false;
}


/**********************************************************************
 *
 * KivioIconView
 *
 **********************************************************************/
KivioIconView::KivioIconView( bool _readWrite,TQWidget *parent, const char *name )
: TQIconView( parent, name )
{
  m_pSpawnerSet = NULL;
  m_pCurDrag = NULL;
  isReadWrite=_readWrite;
  objList.append(this);

  setGridX( 64 );
  setGridY( 64 );
  setResizeMode( Adjust );
  setWordWrapIconText(true);
  setHScrollBarMode( AlwaysOff );
  setVScrollBarMode( Auto );
  setAutoArrange(true);
  setSorting(true);

  setItemsMovable(false);

  setArrangement(LeftToRight);
  setAcceptDrops(false);
  viewport()->setAcceptDrops(false);
  if(isReadWrite) {
    connect(this, TQT_SIGNAL(doubleClicked(TQIconViewItem*)), this, TQT_SLOT(slotDoubleClicked(TQIconViewItem*)));
    connect(this, TQT_SIGNAL(clicked(TQIconViewItem*)), this, TQT_SLOT(slotClicked(TQIconViewItem*)));
  }
}

KivioIconView::~KivioIconView()
{
  objList.remove(this);
  m_pCurDrag = NULL;
}

void KivioIconView::setStencilSpawnerSet( KivioStencilSpawnerSet *pSet )
{
  m_pSpawnerSet = pSet;
  m_pCurDrag = NULL;

  KivioStencilSpawner *pSpawner;
  KivioIconViewItem *pItem;

  pSpawner = pSet->spawners()->first();
  while( pSpawner )
  {
    pItem = new KivioIconViewItem( this );
    pItem->setKey(pSpawner->info()->title());
    pItem->setStencilSpawner(pSpawner);

    pSpawner = pSet->spawners()->next();
  }
}

TQDragObject *KivioIconView::dragObject()
{
  if( !currentItem() || !isReadWrite)
    return 0;

  TQPoint orig = viewportToContents( viewport()->mapFromGlobal( TQCursor::pos() ) );
  KivioSpawnerDrag *drag = new KivioSpawnerDrag( this, viewport() );

  const char*null_pix[]={
  "1 1 1 1",
  "# c None",
  "#"};
  drag->setPixmap(null_pix);

  KivioIconViewItem *item = (KivioIconViewItem *)currentItem();

  TQIconDragItem id;
  TQString full;
  full = item->spawner()->set()->dir() + "/" + item->spawner()->info()->title();
  id.setData( TQCString(full.ascii()));

  drag->append( id,
      TQRect( item->pixmapRect(FALSE).x() - orig.x(),
              item->pixmapRect(FALSE).y() - orig.y(),
              item->pixmapRect().width(),
              item->pixmapRect().height() ),
      TQRect( item->textRect(FALSE).x() - orig.x(),
              item->textRect(FALSE).y() - orig.y(),
              item->textRect().width(),
              item->textRect().height() ),
      *(item->spawner()) );


  // Set the current dragged KivioStencilSpawner for use
  // when the drop occurs.  I don't actually encode the
  // data because it's a pain in the ass and I don't understand
  // how to do it.  So I store a pointer here and clear
  // it on the drop.
  m_pCurDrag = item->spawner();

  return drag;
}

void KivioIconView::clearCurrentDrag()
{
  m_pCurDrag = 0;
}


void KivioIconView::slotDoubleClicked( TQIconViewItem *pTQtItem )
{
  KivioIconViewItem* pItem = dynamic_cast<KivioIconViewItem *>(pTQtItem);

  if( !pItem )
  {
    kdDebug(43000) << "KivioIconView::slotDoubleClicked() - Clicked item is not a KivioIconViewItem!" << endl;
    return;
  }

  KivioStencilSpawner* pSpawner = pItem->spawner();

  emit createNewStencil(pSpawner);
}

void KivioIconView::slotClicked(TQIconViewItem* item)
{
  KivioIconViewItem* stencilItem = dynamic_cast<KivioIconViewItem *>(item);

  if(!stencilItem)
  {
    kdDebug(43000) << "KivioIconView::slotClicked() - Clicked item is not a KivioIconViewItem!" << endl;
    return;
  }

  KivioStencilSpawner* spawner = stencilItem->spawner();
  emit stencilSelected(spawner);
}

#include "kivio_icon_view.moc"
