/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CLEXICONREADWINDOW_H
#define CLEXICONREADWINDOW_H

//BibleTime includes
#include "creadwindow.h"

//TQt includes
#include <tqwidget.h>

//KDE includes
#include <tdeaction.h>

class CSwordKey;
class CSwordLDKey;
//KDE
class TDEToolBarPopupAction;

/**
  *@author The BibleTime team
  */

class CLexiconReadWindow : public CReadWindow  {
	TQ_OBJECT
  
public:
	CLexiconReadWindow(ListCSwordModuleInfo modules, CMDIArea* parent, const char *name=0);
	virtual ~CLexiconReadWindow();
	/**
	* Store the settings of this window in the given CProfileWindow object.
	*/
	//   virtual void storeProfileSettings( CProfileWindow* profileWindow );
	/**
	* Store the settings of this window in the given profile window.
	*/
	//   virtual void applyProfileSettings( CProfileWindow* profileWindow );
	/**
	* Reimplementation.
	*/
	//   static void insertKeyboardActions( TDEAccel* a );
	static void insertKeyboardActions( TDEActionCollection* const a );

protected:
	virtual void initActions();
	virtual void initToolbars();
	virtual void initConnections();
	virtual void initView();
	virtual void updatePopupMenu();
	virtual void setupPopupMenu();


	struct ActionsStruct {
		TDEToolBarPopupAction* backInHistory;
		TDEToolBarPopupAction* forwardInHistory;

		TDEAction* selectAll;
		TDEAction* findText;
		TDEAction* findStrongs;

		TDEActionMenu* copyMenu;
		struct {
			TDEAction* reference;
			TDEAction* entry;
			TDEAction* selectedText;
		}
		copy;

		TDEActionMenu* saveMenu;
		struct {
			TDEAction* reference;
			TDEAction* entryAsPlain;
			TDEAction* entryAsHTML;
		}
		save;

		TDEActionMenu* printMenu;
		struct {
			TDEAction* reference;
			TDEAction* entry;
		}
		print;
	}
	m_actions;

private:
	/**
	* Reimplementation to return the right key.
	*/
	CSwordLDKey* ldKey();

protected slots: // Protected slots
	void previousEntry();
	void nextEntry();
	/**
	* This function saves the entry as html using the CExportMgr class.
	*/
	void saveAsHTML();
	/**
	* This function saves the entry as plain text using the CExportMgr class.
	*/
	void saveAsPlain();
	void slotFillBackHistory();
	void slotFillForwardHistory();

	void slotUpdateHistoryButtons();
};

#endif
