/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2002 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2005-2008 Eike Hein <hein@kde.org>
*/

#ifndef QUERY_H
#define QUERY_H

#include "chatwindow.h"
#include "nickinfo.h"

#include <tqstring.h>

/* TODO: Idle counter to close query after XXX minutes of inactivity */
/* TODO: Use /USERHOST to check if queries are still valid */

class TQLineEdit;
class TQCheckBox;
class TQLabel;
class TQSplitter;

class IRCInput;

namespace Konversation {
  class TopicLabel;
}

class Query : public ChatWindow
{
    TQ_OBJECT
  

    public:
        explicit Query(TQWidget* parent, TQString name);
        virtual void setServer(Server* newServer);

        ~Query();

        /** This will always be called soon after this object is created.
         *  @param nickInfo A nickinfo that must exist.
         */
        void setNickInfo(const NickInfoPtr & nickInfo);
        /** It seems that this does _not_ guaranttee to return non null.
         *  The problem is when you open a query to someone, then the go offline.
         *  This should be fixed maybe?  I don't know.
         */
        NickInfoPtr getNickInfo();
        virtual TQString getTextInLine();
        virtual bool closeYourself(bool askForConfirmation=true);
        virtual bool canBeFrontView();
        virtual bool searchView();

        virtual void setChannelEncoding(const TQString& encoding);
        virtual TQString getChannelEncoding();
        virtual TQString getChannelEncodingDefaultDesc();
        virtual void emitUpdateInfo();

        virtual bool isInsertSupported() { return true; }

        /** call this when you see a nick quit from the server.
         *  @param reason The quit reason given by that user.
         */
        void quitNick(const TQString& reason);

    signals:
        void sendFile(const TQString& recipient);
        void updateQueryChrome(ChatWindow*, const TQString&);

    public slots:
        void sendQueryText(const TQString& text);
        void appendInputText(const TQString& s, bool fromCursor);
        virtual void indicateAway(bool show);
        void updateAppearance();
        void setEncryptedOutput(bool);
        void connectionStateChanged(Server*, Konversation::ConnectionState);

    protected slots:
        void queryTextEntered();
        void queryPassthroughCommand();
        void sendFileMenu();
        void filesDropped(const TQStrList& files);
        // connected to IRCInput::textPasted() - used to handle large/multiline pastes
        void textPasted(const TQString& text);
        void popup(int id);
        void nickInfoChanged();
        void closeWithoutAsking();
        virtual void serverOnline(bool online);

    protected:
        void setName(const TQString& newName);
        void showEvent(TQShowEvent* event);
        /** Called from ChatWindow adjustFocus */
        virtual void childAdjustFocus();

        bool awayChanged;
        bool awayState;

        TQString queryName;
        TQString buffer;

        TQSplitter* m_headerSplitter;
        Konversation::TopicLabel* queryHostmask;
        TQLabel* addresseeimage;
        TQLabel* addresseelogoimage;
        TQLabel* awayLabel;
        TQLabel* blowfishLabel;
        IRCInput* queryInput;
        NickInfoPtr m_nickInfo;

        bool m_initialShow;
};
#endif
