/***************************************************************************
                          actions.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "actions.h"

// include files for QT

#include <tqwhatsthis.h>
#include <tqdragobject.h>
#include <tqcombobox.h>
#include <tqapplication.h>

// include files for KDE
#include <tdetoolbar.h>
#include <kiconloader.h>
#include <kmimetype.h>
#include <kdebug.h>

//-------------------------------------------------------------------
//
// KXmlEditorComboAction member functions
//
//-------------------------------------------------------------------

KXmlEditorComboAction::KXmlEditorComboAction(const TQString& text,
                                             int accel,
                                             const TQObject *receiver,
                                             const char *member,
                                             TQObject* parent,
                                             const char* name)
    : TDEAction(text, accel, parent, name),
      m_pCombo(0)
{
	m_receiver = receiver;
  m_member = member;
}

KXmlEditorComboAction::~KXmlEditorComboAction()
{
	//delete m_pCombo; // L.V. this cause crash !!!
}

TQComboBox* KXmlEditorComboAction::comboBox()
{
 	return m_pCombo;
}

int KXmlEditorComboAction::plug(TQWidget *w, int index)
{
  //  if ( !w->inherits( "TDEToolBar" ) );
  //    return -1;

  TDEToolBar *toolBar = (TDEToolBar *) w;

  int id = TDEAction::getToolButtonID();
  //kdDebug() << "KXmlEditorComboAction::plug id=" << id << endl;

  m_pCombo = new TQComboBox( toolBar, "Path Combo" );
  m_pCombo->setEditable(true);
  m_pCombo->setInsertionPolicy(TQComboBox::NoInsertion);
  toolBar->insertWidget( id, 70, m_pCombo, index );
  connect( m_pCombo, SIGNAL(activated(const TQString&)), m_receiver, m_member );

  addContainer( toolBar, id );

  connect(toolBar, SIGNAL(destroyed()), this, SLOT(slotDestroyed()));

  toolBar->setItemAutoSized(id, true);

  TQWhatsThis::add( m_pCombo, whatsThis() );

  return containerCount() - 1;
}

void KXmlEditorComboAction::unplug(TQWidget *w)
{
//  if ( !w->inherits( "TDEToolBar" ) )
//    return;

  TDEToolBar *toolBar = (TDEToolBar *)w;

  int idx = findContainer( w );
  //kdDebug() << "KXmlEditorComboAction::unplug idx=" << idx << " menuId=" << menuId(idx) << endl;

  toolBar->removeItem( menuId( idx ) );

  removeContainer( idx );
  m_pCombo = 0;
}

void KXmlEditorComboAction::slotClear()
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::slotClear] action not plugged" << endl;
    return;
  }

  m_pCombo->clear();
}

void KXmlEditorComboAction::slotClearEdit()
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::slotClearEdit] action not plugged" << endl;
    return;
  }

  m_pCombo->clearEdit();
}

void KXmlEditorComboAction::slotFocusEdit()
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::slotFocusEdit] action not plugged" << endl;
    return;
  }

  m_pCombo->setFocus();
}

TQString KXmlEditorComboAction::currentText() const
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::currentText] action not plugged" << endl;
    return TQString::null;
  }

  return m_pCombo->currentText();
}

const TQPixmap * KXmlEditorComboAction::currentPixmap() const
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::currentPixmap] action not plugged" << endl;
    return 0;
  }

  return m_pCombo->pixmap( m_pCombo->currentItem() );
}

void KXmlEditorComboAction::insertItem( const TQPixmap & pixmap, const TQString & text )
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::insertItem] action not plugged" << endl;
    return;
  }

	if ( text.isEmpty() )
    kdWarning() << "[KXmlEditorComboAction::insertItem] empty string as parameter" << endl;

  int nIndex = findItem(text);
  if ( nIndex != -1 )
    m_pCombo->removeItem(nIndex);

  m_pCombo->insertItem( pixmap, text, 0 );
  m_pCombo->setCurrentItem(0);

  if ( m_pCombo->count() > 15 )
    m_pCombo->removeItem(15);
}

void KXmlEditorComboAction::removeItem( const TQString & text )
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::removeItem] action not plugged" << endl;
    return;
  }

  int nIndex = findItem(text);
  if ( nIndex == -1 )
  {
    kdDebug() << "KXmlEditorComboAction::removeItem] item not found" << endl;
    return;
  }

  m_pCombo->removeItem(nIndex);
}

int KXmlEditorComboAction::findItem( const TQString & text )
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::findItem] action not plugged" << endl;
    return -1;
  }

  int nIndex = -1;
  int i=0;
  while ( ( i < m_pCombo->count() ) && ( nIndex == -1 ) )
  {
    if ( m_pCombo->text(i) == text )
      nIndex = i;
    i++;
  }

  return nIndex;
}

ToolbarLabel::ToolbarLabel(  const TQString& text )
  : TQLabel( text, 0L, "tde toolbar widget" )	// Use this name for it to be styled!
//  , m_mw(mw)
{
  setBackgroundMode( TQt::PaletteButton );
  setAlignment( (TQApplication::reverseLayout() ? TQt::AlignRight : TQt::AlignLeft) |
                 TQt::AlignVCenter | TQt::ShowPrefix );
  adjustSize();
  }

#include "actions.moc"
