// $Id$
//
// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include <tqlayout.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

#include <tdeapplication.h>

#include "BackupOptDlg.h"
#include "BackupProfileWidget.h"
#include <tdelocale.h>

#include "BackupOptDlg.moc"

BackupOptDlg::BackupOptDlg( BackupProfile* backupProfile, TQWidget* parent, const char* name )
        : TQDialog( parent, name, TRUE )
{
    setIconText( i18n( "KDat: Backup Options" ) );
    setCaption( i18n( "KDat: Backup Options" ) );

    resize( 400, 300 );

    _profile = new BackupProfileWidget( this );
    _profile->setBackupProfile( backupProfile );

    KPushButton* ok = new KPushButton( KStdGuiItem::ok(), this );
    ok->setFixedSize( 80, ok->sizeHint().height() );
    connect( ok, TQT_SIGNAL( clicked() ), this, TQT_SLOT( accept() ) );
    KPushButton* cancel = new KPushButton( KStdGuiItem::cancel(), this );
    cancel->setFixedSize( 80, ok->sizeHint().height() );
    connect( cancel, TQT_SIGNAL( clicked() ), this, TQT_SLOT( reject() ) );

    TQVBoxLayout* l1 = new TQVBoxLayout( this, 8, 4 );
    l1->addWidget( _profile, 1 );

    TQHBoxLayout* l1_1 = new TQHBoxLayout();
    l1->addLayout( l1_1 );
    l1_1->addStretch( 1 );
    l1_1->addWidget( ok );
    l1_1->addWidget( cancel );

    ok->setDefault( TRUE );
}

BackupOptDlg::~BackupOptDlg()
{
}

TQString BackupOptDlg::getArchiveName()
{
    return _profile->getArchiveName();
}

TQString BackupOptDlg::getWorkingDirectory()
{
    return _profile->getWorkingDirectory();
}

const TQStringList& BackupOptDlg::getRelativeFiles()
{
    return _profile->getRelativeFiles();
}

bool BackupOptDlg::isOneFilesystem()
{
    return _profile->isOneFilesystem();
}

bool BackupOptDlg::isIncremental()
{
    return _profile->isIncremental();
}

TQString BackupOptDlg::getSnapshotFile()
{
    return _profile->getSnapshotFile();
}

bool BackupOptDlg::getRemoveSnapshot()
{
    return _profile->getRemoveSnapshot();
}
