#ifndef __TDEMIDPART_H__
#define __TDEMIDPART_H__

#include <tdeparts/browserextension.h>
#include <tdeparts/factory.h>
#include <tdelibs_export.h>
class TDEAboutData;
class TDEInstance;
class KMidBrowserExtension;
class tdemidClient;

class KDE_EXPORT KMidFactory : public KParts::Factory
{
  TQ_OBJECT
  
  public:
    KMidFactory();
    virtual ~KMidFactory();

    virtual KParts::Part* createPartObject(TQWidget *parentWidget, const char *widgetName,
                TQObject* parent = 0, const char* name = 0,
                const char* classname = "TQObject",
                const TQStringList &args = TQStringList());

    static TDEInstance *instance();

    static TDEAboutData *aboutData();
  private:
    static TDEInstance *s_instance;
};

class KMidPart: public KParts::ReadOnlyPart
{
  TQ_OBJECT
  
  public:
    KMidPart(TQWidget *parentWidget, const char *widgetName, 
             TQObject *parent, const char *name);
    virtual ~KMidPart();


    virtual bool closeURL();

  protected:
    virtual bool openFile();

  protected slots:
    void slotPlay();
    void slotStop();

  private:
    tdemidClient *widget;
    KMidBrowserExtension *m_extension;
};

class KMidBrowserExtension : public KParts::BrowserExtension
{
  TQ_OBJECT
  
    friend class KMidPart;
  public:
  KMidBrowserExtension(KMidPart *parent);
  virtual ~KMidBrowserExtension();
};

#endif
