#################################################
#
#  (C) 2017 Slávek Banko
#  slavek (DOT) banko (AT) axis.cz
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

if( WITH_KSCD_CDDA AND NOT BUILD_CDDA )

  if( "${CMAKE_SYSTEM_NAME}" MATCHES "Linux" )

    check_include_file( pthread.h HAVE_PTHREAD_H )
    check_c_source_compiles( "
#ifndef __GNUC__
#define __GNUC__ 1
#endif
/* needed for vanilla kernel headers, which do provide __u64 only
   for ansi */
#undef __STRICT_ANSI__
/* needed for non-ansi kernel headers */
#define asm __asm__
#define inline __inline__
#include <linux/types.h>
#include <linux/cdrom.h>
#undef asm
#undef inline

int main() {
  #if defined(__linux__)
    ioctl(1, CDROMREADAUDIO, 0);
  #else
    #error platform?
  #endif
}"
      BUILD_CDDA )
    if( NOT BUILD_CDDA )
        tde_message_fatal( "cdda support is requested, but not avaiable on your system" )
    endif( NOT BUILD_CDDA )

  elseif( ${CMAKE_SYSTEM_NAME} MATCHES "SunOS" )

    check_include_file( pthread.h HAVE_PTHREAD_H )
    check_c_source_compiles( "
#include <sys/types.h>
#include <sys/cdio.h>

int main() {
  #if defined(__sun) || defined(sun)
    ioctl(1, CDROMCDDA, 0);
  #else
    #error platform?
  #endif
}"
      BUILD_CDDA )
    if( NOT BUILD_CDDA )
        tde_message_fatal( "cdda support is requested, but not avaiable on your system" )
    endif( NOT BUILD_CDDA )

  else( )

    message( STATUS "Checking cdda support - not available on this system type" )

  endif( )

endif( WITH_KSCD_CDDA AND NOT BUILD_CDDA )
