/*
    certificatewizardimpl.h

    This file is part of Kleopatra, the KDE keymanager
    Copyright (c) 2001,2002,2004 Klarlvdalens Datakonsult AB

    Kleopatra is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Kleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifndef CERTIFICATEWIZARDIMPL_H
#define CERTIFICATEWIZARDIMPL_H
#include "certificatewizard.h"

#include <tqcstring.h>
#include <tqvaluevector.h>
#include <tqlineedit.h>
#include <kurl.h>

namespace GpgME {
  class KeyGenerationResult;
}
namespace TDEIO {
  class Job;
}

class CertificateWizardImpl : public CertificateWizard
{
    TQ_OBJECT
  

public:
    CertificateWizardImpl( TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~CertificateWizardImpl();

    bool sendToCA() const;
    TQString caEMailAddress() const;
    KURL saveFileUrl() const;

    typedef TQPair<TQString, TQLineEdit*> StringLEPair;
    typedef TQValueVector< StringLEPair > AttrPairList;

public:
    virtual void showPage( TQWidget * page );
    virtual void accept();

private slots:
    void slotGenerateCertificate();
    void slotResult( const GpgME::KeyGenerationResult & res, const TQByteArray & keyData );
    void slotSetValuesFromWhoAmI();
    void slotEnablePersonalDataPageExit();
    void slotURLSelected( const TQString& );

    void slotHelpClicked();

    void slotUploadResult( TDEIO::Job* );

private:
    void createPersonalDataPage();
    void sendCertificate( const TQString& email, const TQByteArray& certificateData );

private:
    AttrPairList _attrPairList;
    TQByteArray _keyData;
};

#endif // CERTIFICATEWIZARDIMPL_H
