#!/bin/bash
#
# Create/update TDE local debian repository
#

# Load common code and initialization
export SCRIPT_DIR=$(dirname $(readlink -f "$0"))
. ${SCRIPT_DIR}/internals/_build_common.sh
init_common

#----------------------------
# Check command line arguments
parm_MAKE_BACKUP="n"
for arg in $@; do
	if [ "$arg" = "-b" ]; then    				# backup old repository
		parm_MAKE_BACKUP="y"
	fi
done


#----------------------------
# Create/update TDE local debian repository
echo -e "${CLightCyan}####  TDE local repository creation begin  ####${CNone}"
ARCH_PATH="dists/$DISTRO_NAME/main/binary-$ARCHITECTURE"
REPO_DIR="$TDE_DIR/$CFG_REPO_DIR"
REPO_DIR_BACKUP="$REPO_DIR.backup"
REPO_PKG_DIR="$REPO_DIR/$ARCH_PATH"

# Backup
if [ "$parm_MAKE_BACKUP" = "y" ] && [ -d "$REPO_DIR" ]; then
  echo -e "${CYellow}> Backing up old repository${CNone}"
  rm -R "$REPO_DIR_BACKUP" &>/dev/null
  mv "$REPO_DIR" "$REPO_DIR_BACKUP" &>/dev/null
  echo "Copy of the old repository available at \"$REPO_DIR_BACKUP\""
fi

# Create repository
echo -e "${CYellow}> Creating new repository${CNone}"
if [ -d "$REPO_DIR" ]; then
  rm -R "$REPO_DIR" &>/dev/null
fi
mkdir -p "$REPO_PKG_DIR"
rsync -aHS --exclude="*/src/*.xz" --exclude="*/src/*.dsc" --exclude="*/src/*.changes" --exclude="*/src/*.buildinfo" --exclude="Packages*" "$TDE_DEBS_DIR/" "$REPO_PKG_DIR/"

# Create package index file
echo -e "${CYellow}> Creating package index file${CNone}"
cd "$REPO_DIR"
dpkg-scanpackages "./$ARCH_PATH" | gzip -9c > "./$ARCH_PATH/Packages.gz"


#----------------------------
# Repository created
echo -e "${CLightGreen}####  TDE local repository created  ####${CNone}"
cd "$SCRIPT_DIR"
exit 0
