#!/usr/bin/env python
"""

"""
import sys

from PyTQt.tqt import TQIconSet, TQProcess, TQTimer, SIGNAL, SLOT

from tdecore import TDEAboutData, TDEApplication, TDECmdLineArgs, TDEGlobal, TDEIcon
from tdecore import KWin, KWinModule
from tdeui import KComboBox, TDEMainWindow, KPushButton, QXEmbed


## add the missing items to the pytquic-generated module
import qxembedexample
qxembedexample.KComboBox = KComboBox
qxembedexample.KPushButton = KPushButton

from qxembedexample import QXEmbedExample


def getIcon(name, group=TDEIcon.NoGroup, size=TDEIcon.SizeSmall):
    """ returns a kde icon by name

    """
    return TDEGlobal.instance().iconLoader().loadIcon(name, group, size)

def getIconSet(name, group=TDEIcon.NoGroup, size=TDEIcon.SizeSmall):
    """ returns a kde icon set by name

    """
    return TDEGlobal.instance().iconLoader().loadIconSet(name, group, size)


def getWindow(pid):
    """ return a window info object for the process id (or None)

    """
    for winid in KWinModule().windows():
        info = KWin.info(winid)
        if pid == info.pid:
            return info


class ExampleForm(QXEmbedExample):
    """ wraps the pyqtuic generated form class with our behavior

    """
    def __init__(self, parent):
        QXEmbedExample.__init__(self, parent)
        combo = self.appNameCombo
        items = [(idx, '%s' % combo.text(idx)) for idx in range(combo.count())]
        for idx, name in items:
            combo.changeItem(getIcon(name), name, idx)
        self.mainTabs.setTabIconSet(self.tab, getIconSet('help'))
        self.launchButton.setIconSet(getIconSet('exec'))
        self.launchButton.setText('Launch and Embed')

    def launchApp(self):
        """ launch the process selected in the combo

        """
        name = self.appNameCombo.currentText()
        self.proc = proc = TQProcess()
        proc.addArgument(name)
        code = proc.start()
        if code:
            pid = proc.processIdentifier()
            self.launchPid = pid ## cheap
            TQTimer.singleShot(2000, self.embedLaunchedWindow)
        else:
            print('failed to start %s' % name)
            return

    def embedLaunchedWindow(self):
        """ embed the window of the last launched pid

        """
        pid = self.launchPid
        winobj = getWindow(pid)
        if winobj:
            tabs = self.mainTabs
            embedded = QXEmbed(self)
            caption = '%s (%s)' % (winobj.name, pid, )
            tabs.insertTab(embedded, caption)
            embedded.embed(winobj.win)
            tabs.showPage(embedded)
            pxm = KWin.icon(winobj.win)
            tabs.setTabIconSet(embedded, TQIconSet(pxm))


class ExampleMain(TDEMainWindow):
    """ an example main window

    """
    def __init__ (self, *args):
        TDEMainWindow.__init__(self, *args)
        self.setGeometry(0, 0, 400, 400)
        self.embed = embed = ExampleForm(self)
        self.setCentralWidget(embed)


if __name__ == '__main__':
    aname = b'PyTDE QXEmbed Sample'
    desc = b'A Simple PyTDE QXEmbed Sample'
    ver = b'1.0'
    lic = TDEAboutData.License_GPL
    author = b'Troy Melhase'
    authormail = b'troy@gci.net'

    about = TDEAboutData(aname, aname, ver, desc, lic, b'troy@gci.net (c) 2004')
    about.addAuthor(author, b'hi, mom!', authormail)
    about.addAuthor (b'Jim Bublitz', b'For PyTDE', b'jbublitz@nwinternet.com')
    TDECmdLineArgs.init(sys.argv, about)
    app = TDEApplication()
    mainWindow = ExampleMain()
    mainWindow.show()
    app.connect(app, SIGNAL('lastWindowClosed()'), app, SLOT('quit()'))
    app.exec_loop()
