from PyTQt.tqt import TQVBox, TQLabel, TQLineEdit, TQString, TQPixmap, TQPushButton, TQColor, SIGNAL, TQButtonGroup,\
               TQRadioButton, TQt, TQWidget

from tdecore import TDEAccel, i18n

from tdeui import TDEAboutDialog, TDEAboutKDE, KBugReport, KColorDialog,  KDialog, KDialogBase, TDEFontDialog,\
                  KPasswordDialog, KMessageBox, KLineEditDlg, KKeyDialog, KWizard

# despite what the docs say, there is no enum (in 2.1.1 anyway)
# that contains these values
QuestionYesNo         = 0
WarningYesNo          = 1
WarningContinueCancel = 2
WarningYesNoCancel    = 3
Information           = 4
Sorry                 = 5
Error                 = 6

class CustomDlg (KDialog):
    def __init__ (self, parent, name = "custom dlg", modal = False):
        KDialog.__init__ (self, parent, name, modal)

        x = 20
        y = 10

        rLbl        = TQLabel ("r", self)
        gLbl        = TQLabel ("g", self)
        bLbl        = TQLabel ("b", self)
        self.rEd    = TQLineEdit ("64", self)
        self.gEd    = TQLineEdit ("64", self)
        self.bEd    = TQLineEdit ("64", self)
        self.dlgBtn = TQPushButton ("Set/Get Color", self)
        self.okBtn  = TQPushButton ("OK", self)
        self.canBtn = TQPushButton ("Cancel", self)

        rLbl.setGeometry (x, y, 25, 20)
        gLbl.setGeometry (x + 30, y, 25, 20)
        bLbl.setGeometry (x + 60, y, 25, 20)
        y = y + 20
        self.rEd.setGeometry (x, y, 25, 20)
        self.gEd.setGeometry (x + 30, y, 25, 20)
        self.bEd.setGeometry (x + 60, y, 25, 20)
        y = y + 30
        self.dlgBtn.setGeometry (x, y, 90, 22)
        y = y + 30
        self.okBtn.setGeometry (x, y, 40, 22)
        self.canBtn.setGeometry (x + 50, y, 40, 22)

        self.connect (self.dlgBtn, SIGNAL ("clicked()"), self.dlgClicked)
        self.connect (self.okBtn, SIGNAL ("clicked ()"), self.okClicked)
        self.connect (self.canBtn, SIGNAL ("clicked ()"), self.cancelClicked)

    def dlgClicked (self):
        # get some (numerical) color values from the original dialog
        red   = int (self.rEd.text ().latin1 ())
        green = int (self.gEd.text ().latin1 ())
        blue  = int (self.bEd.text ().latin1 ())

        # convert the numbers to a TQColor
        color = TQColor (red, green, blue)

        # invoke the dialog (getColor is a 'static' call)
        # initialize with the colors from above (in color)
        # color will also hold the new value chosen in the
        # KColorDialog
        result = KColorDialog.getColor (color, self)

        # get the numerical color values back
        red, green, blue = color.rgb ()

        # update the TQLineEdits in the original dialog
        self.rEd.setText (str (red))
        self.gEd.setText (str (green))
        self.bEd.setText (str (blue))

    def okClicked (self):
        self.done (1)

    def cancelClicked (self):
        self.done (0)

class MessageDlg (KDialog):
    def __init__ (self, parent, name = "message dlg", modal = False):
        KDialog.__init__ (self, parent, name, modal)

        buttons = ["QuestionYesNo", "WarningYesNo", "WarningContiueCancel", "WarningYesNoCancel",\
                   "Information", "Sorry", "Error"]

        n = len (buttons)

        grp = TQButtonGroup (n, TQt.Vertical, "MessageBoxes", self, "button grp")
        grp.setGeometry (10, 10, 200, 30*n)
        for i in range (n):
            TQRadioButton (buttons [i], grp)

        self.connect (grp, SIGNAL ("clicked (int)"), self.launch)

    def launch (self, which):
        if which == QuestionYesNo:
            KMessageBox.questionYesNo (self, "This is a questionYesNo message box\nThere is also a list version of this dialog",\
                                       "questionYesNo")

        elif which == WarningYesNo:
            KMessageBox.warningYesNo (self, "This is a warningYesNo message box", "warningYesNo")

        elif which == WarningContinueCancel:
            KMessageBox.warningContinueCancel (self, "This is a warningContinueCancel message box", "warningContinueCancel");

        elif which == WarningYesNoCancel:
            KMessageBox.warningYesNoCancel (self, "This is a warningYesNoCancel message box", "warningYesNoCancel")

        elif which == Information:
            KMessageBox.information (self, "This is an information message box", "Information")

        elif which == Sorry:
            KMessageBox.sorry (self, "This is a 'sorry' message box", "Sorry")

        elif which == Error:
            KMessageBox.error (self, "No - this isn't really an error\nIt's an error message box\n", "Error")


def dlgTDEAboutDialog (parent):
    dlg = TDEAboutDialog (parent, 'about dialog', False)
    dlg.setLogo (TQPixmap ("pytestimage.png"))
    dlg.setTitle ("UISampler for PyTDE")
    dlg.setAuthor ("Jim Bublitz", "jbublitz@nwinternet.com", "http://www.riverbankcomputing.co.uk",\
                    "\n\nPyTDE -- Python bindings\n\tfor TDE")
    dlg.addContributor ("PyTDE list", "pytde@mats.gmd.de", TQString.null, TQString.null)

    dlg.show ()


def dlgKBugReport (parent):
    dlg = KBugReport (parent)
    dlg.exec_loop ()

def dlgTDEAboutKDE (parent):
    dlg = TDEAboutKDE (parent, "about kde", False)
    dlg.show ()

def dlgKColorDialog (parent):
    dlg = KColorDialog (parent, "color dlg", False)
    dlg.show ()

def dlgKDialog (parent):
    dlg = CustomDlg (parent)
    dlg.show ()

def dlgKDialogBase (parent):
    caption = "KDialogBase sample"
    text_ = "This is a KDialogBase example"
    dlg =   KDialogBase (parent, "sample_dialog", False, caption,\
            KDialogBase.Ok | KDialogBase.Cancel, KDialogBase.Ok, True )

    page  = dlg.makeVBoxMainWidget();

    # making 'page' the parent inserts the widgets in
    # the VBox created above
    label = TQLabel( caption, page, "caption" );

    lineedit = TQLineEdit(text_, page, "lineedit" );
    lineedit.setMinimumWidth(dlg.fontMetrics().maxWidth()*20);

    # This tests some handwritten code in KDialogBase
    label0 = TQLabel ("Border widths", page)
    a, b, c, d = dlg.getBorderWidths ()
    labelA = TQLabel ("Upper Left X: " + str (a), page)
    labelB = TQLabel ("Upper Left Y: " + str (b), page)
    labelC = TQLabel ("Lower Right X: " + str (c), page)
    labelD = TQLabel ("Lower Right Y: " + str (d), page)

    dlg.show ()

def dlgTDEFontDialog (parent):
    dlg = TDEFontDialog (parent, "font dlg", False, False)
    dlg.show ()

def dlgKKeyDialog (parent):
    # This really doesn't do anything except pop up the dlg
    keys = TDEAccel (parent)
    keys.insertItem( i18n( "Zoom in" ), "Zoom in", "+" );
    keys.readSettings();
    KKeyDialog.configureKeys (keys)

def dlgKLineEditDlg (parent):
    result, ok = KLineEditDlg.getText ("Enter text", "<Your input here>", parent)
    print("result", result)
    print("ok", ok)

    # pop up another dlg to show what happened in the KLineEditDlg
    if ok:
        result = result.latin1 ()
        KMessageBox.information (parent, "OK was pressed\nText: " + result, "KLineEditDlg result")
    else:
        result = ""
        KMessageBox.information (parent, "Cancel pressed\nText: " + result, "KLineEditDlg result")

def dlgKMessageBox (parent):
    dlg = MessageDlg (parent)
    dlg.show ()

def dlgKPasswordDialog (parent):
    dlg = KPasswordDialog (KPasswordDialog.Password, "Enter password (just a test)")
    dlg.exec_loop ()

def dlgKWizard (parent):
    wiz = KWizard (parent)

    page1 = TQWidget (wiz)
    p1Lbl = TQLabel ("This is page 1", page1)
    p1Lbl.setGeometry (20, 20, 100, 20)
    page2 = TQWidget (wiz)
    p2Lbl = TQLabel ("This is page 2", page2)
    p2Lbl.setGeometry (50, 20, 100, 20)
    page3 = TQWidget (wiz)
    p3Lbl = TQLabel ("This is page 3", page3)
    p3Lbl.setGeometry (80, 20, 100, 20)

    wiz.addPage (page1, "Page 1")
    wiz.addPage (page2, "Page 2")
    wiz.addPage (page3, "Page 3")
    wiz.show ()

if __name__ == "__main__":
    print()
    print("Please run uisampler.py")
    print()
