/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2003-10-22
 * Description : preview raw file widget used in single convert
 *
 * Copyright (C) 2003-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */


#ifndef PREVIEWWIDGET_H
#define PREVIEWWIDGET_H

// TQt includes.

#include <tqcolor.h>
#include <tqframe.h>
#include <tqpixmap.h>
#include <tqstring.h>

class TQPaintEvent;
class TQResizeEvent;

namespace KIPIRawConverterPlugin
{
class PreviewWidgetPriv;

class PreviewWidget : public TQFrame
{
    Q_OBJECT
  
    
public:

    PreviewWidget(TQWidget *parent);
    ~PreviewWidget();

    void load(const TQString& file);
    void setInfo(const TQString& text, const TQColor& color=TQt::white, 
                 const TQPixmap& preview=TQPixmap());

protected:

    void paintEvent(TQPaintEvent *e);
    void resizeEvent(TQResizeEvent *e);

private slots:

    void slotResize();
    
private:

    PreviewWidgetPriv* d;
};

} // NameSpace KIPIRawConverterPlugin

#endif /* PREVIEWWIDGET_H */
