#!/usr/bin/env python

"""**************************************************************************
** $Id: rangecontrols.py,v 1.1 2003/07/01 14:18:37 phil Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from PyTQt.tqt import *

INT_MAX = sys.maxsize

class RangeControls( TQVBox ):
    def __init__( self, parent=None, name=None ):
        TQVBox.__init__( self, parent, name )
        
        row1  = TQHBox( self )
        cell2 = TQVBox( row1 )
        cell2.setMargin( 10 )
        cell2.setFrameStyle( TQFrame.WinPanel | TQFrame.Sunken )

        TQWidget( cell2 )

        label1 = TQLabel( TQString( "Enter a value between\n%1 and %2:" ).arg( -INT_MAX ).arg( INT_MAX ), cell2 )
        label1.setMaximumHeight( label1.sizeHint().height() )
        sb1 = TQSpinBox( -INT_MAX, INT_MAX, 1, cell2 )
        sb1.setValue( 0 )

        label2 = TQLabel( "Enter a zoom value:", cell2 )
        label2.setMaximumHeight( label2.sizeHint().height() )
        sb2 = TQSpinBox( 0, 1000, 10, cell2 )
        sb2.setSuffix( " %" )
        sb2.setSpecialValueText( "Automatic" )

        label3 = TQLabel( "Enter a price:", cell2 )
        label3.setMaximumHeight( label3.sizeHint().height() )
        sb3 = TQSpinBox( 0, INT_MAX, 1, cell2 )
        sb3.setPrefix( "$" )
        sb3.setValue( 355 )

        TQWidget( cell2 )

        row2 = TQHBox( self )

        cell3 = TQVBox( row2 )
        cell3.setMargin( 10 )
        cell3.setFrameStyle( TQFrame.WinPanel | TQFrame.Sunken )
        hslider = TQSlider( 0, 64, 1, 33, TQt.Horizontal, cell3 )
        lcd2 = TQLCDNumber( 2, cell3 )
        lcd2.display( 33 )
        lcd2.setSegmentStyle( TQLCDNumber.Filled )
        self.connect( hslider, SIGNAL("valueChanged( int )"), lcd2, SLOT("display( int )") )

        cell4 = TQHBox( row2 )
        cell4.setFrameStyle( TQFrame.WinPanel | TQFrame.Sunken )
        cell4.setMargin( 10 )
        vslider = TQSlider( 0, 64, 1, 8, TQt.Vertical, cell4 )
        lcd3 = TQLCDNumber( 3, cell4 )
        lcd3.display( 8 )
        self.connect( vslider, SIGNAL("valueChanged( int )"), lcd3, SLOT("display( int )") )

def main( args ):
    a = TQApplication( args )
    
    rangecontrols = RangeControls()
    rangecontrols.resize( 500, 300 )
    rangecontrols.setCaption( "TQt Example - Range Control Widgets" );
    a.setMainWidget( rangecontrols )
    rangecontrols.show()
    
    a.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
