#include "visualboyadvance_part.h"

#include <tqvbox.h>
#include <tqwhatsthis.h>

#include <tdeaction.h>
#include <kdevgenericfactory.h>
#include <kiconloader.h>
#include <tdelocale.h>

#include "kdevcore.h"
#include "kdevproject.h"
#include "kdevappfrontend.h"
#include "domutil.h"
#include "kdevplugininfo.h"

#include "vbaconfigwidget.h"


using namespace VisualBoyAdvance;

typedef KDevGenericFactory<VisualBoyAdvancePart> VisualBoyAdvanceFactory;
static const KDevPluginInfo pluginData("kdevvisualboyadvance");
K_EXPORT_COMPONENT_FACTORY( libkdevvisualboyadvance, VisualBoyAdvanceFactory( pluginData ) )
  
VisualBoyAdvancePart::VisualBoyAdvancePart(TQObject *parent, const char *name, const TQStringList &)
  : KDevPlugin(&pluginData, parent, name){
  setInstance(VisualBoyAdvanceFactory::instance());

  setXMLFile("kdevpart_visualboyadvance.rc");
  
  TDEAction *action;
  action = new TDEAction( i18n("Execute Program"), "application-x-executable",  Key_F9,
			this, TQT_SLOT(slotExecute()),
			actionCollection(), "build_execute" );

  connect( core(), TQT_SIGNAL(projectConfigWidget(KDialogBase*)),
	   this, TQT_SLOT(projectConfigWidget(KDialogBase*)) );
}


VisualBoyAdvancePart::~VisualBoyAdvancePart()
{
  
}
void VisualBoyAdvancePart::slotExecute(){
  KDevProject* prj = project();
  TQDomDocument &doc = *projectDom();
  TQString binary = DomUtil::readEntry(doc, "/kdevvisualadvance/binary");
  TQString emulator = DomUtil::readEntry(doc, "/kdevvisualadvance/emulator");
  TQString graphicFilter = DomUtil::readEntry(doc, "/kdevvisualadvance/graphicFilter");
  TQString scaling = DomUtil::readEntry(doc, "/kdevvisualadvance/scaling");
  TQString addOptions = DomUtil::readEntry(doc, "/kdevvisualadvance/addOptions");
  bool terminal = DomUtil::readBoolEntry(doc, "/kdevvisualadvance/terminal");
  bool fullscreen = DomUtil::readBoolEntry(doc, "/kdevvisualadvance/fullscreen");

  if(emulator.isNull()) emulator = "VisualBoyAdvance";
  TQString program = emulator + " " + graphicFilter +" " + scaling + " " + addOptions +" ";
  if(fullscreen){
    program += "-F ";
  }

  program += prj->projectDirectory() + "/" + binary;

  if (KDevAppFrontend *appFrontend = extension<KDevAppFrontend>("TDevelop/AppFrontend"))
      appFrontend->startAppCommand(TQString(), program, terminal);
}

void VisualBoyAdvancePart::projectConfigWidget(KDialogBase *dlg){
  TQVBox *vbox;
  vbox = dlg->addVBoxPage(i18n("Run Options"), i18n("Run Options"), BarIcon( "text-x-makefile", TDEIcon::SizeMedium ));
  VBAConfigWidget* w = new VBAConfigWidget(this,vbox);
  connect( dlg, TQT_SIGNAL(okClicked()), w, TQT_SLOT(accept()) );
}
  

#include "visualboyadvance_part.moc"
