class TDEIconLoader;

class WeatherIconPrivate {
	friend class WeatherIcon;

	public:
		WeatherIconPrivate();
		~WeatherIconPrivate();

		static WeatherIconPrivate* instance();

		void useIconTheme( bool use );
		bool usingIconTheme();

		TQString iconPath( TQString icon, bool inTheme );
		TQString iconPath( TQString icon );

	private:
		static WeatherIconPrivate* s_instance;
		TDEIconLoader* iconLoader;
		bool m_useIconTheme;

		TQPair<TQString,TQString> findIcon( TQStringList fallback );
};

class WeatherIcon {
	public:
		enum SimpleCondition { Sunny, Fog, Mist, Overcast, Hail, LightRain, Sleet };
		enum RangedCondition { Cloudy, Showers, Snow, Thunderstorm };

		WeatherIcon( int condition /* SimpleCondition */, bool night );
		WeatherIcon( int condition /* RangedCondition */, bool night, unsigned int strength );
		~WeatherIcon();

		static TQString unknown() { return "weather-none-available"; };
		TQString name() { return iconName; }
		TQString path() { return iconPath; }

	private:
		TQString iconName;
		TQString iconPath;
};
