//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQColor;
import org.trinitydesktop.qt.TQRect;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQPixmap;
import org.trinitydesktop.qt.TQImage;
import org.trinitydesktop.qt.TQWidget;

/**

 Applies effects to icons.
 This class applies effects to icons depending on their state and
 group. For example, it can be used to make all disabled icons
 in a toolbar gray.
		@short    Applies effects to icons.
		@see TDEIcon

*/
public class TDEIconEffect implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected TDEIconEffect(Class dummy){}

	/**
		 This is the enumeration of all possible icon effects.
		 Note that 'LastEffect' is no valid icon effect but only
		 used internally to check for invalid icon effects.

			<li>
			NoEffect: Don't apply any icon effect
			</li>

			<li>
			ToGray: Tints the icon gray
			</li>

			<li>
			Colorize: Tints the icon with an other color
			</li>

			<li>
			ToGamma: Change the gamma value of the icon
			</li>

			<li>
			DeSaturate: Reduce the saturation of the icon
			</li>

			<li>
			ToMonochrome: Produces a monochrome icon

			</li>		@short    This is the enumeration of all possible icon effects.
	*/
	public static final int NoEffect = 0;
	public static final int ToGray = 1;
	public static final int Colorize = 2;
	public static final int ToGamma = 3;
	public static final int DeSaturate = 4;
	public static final int ToMonochrome = 5;
	public static final int LastEffect = 6;

	/**
		 Create a new TDEIconEffect.
		   		@short    Create a new TDEIconEffect.
	*/
	public TDEIconEffect() {
		newTDEIconEffect();
	}
	private native void newTDEIconEffect();
	/**
		 Rereads configuration.
		     		@short    Rereads configuration.
	*/
	public native void init();
	/**
		 Tests whether an effect has been configured for the given icon group.
			@param group the group to check, see TDEIcon.Group
			@param state the state to check, see TDEIcon.States
				@return true if an effect is configured for the given <code>group</code>
 in <code>state</code>, otherwise false.

		@short    Tests whether an effect has been configured for the given icon group.
		@see TDEIcon#Group
		@see TDEIcon#States
	*/
	public native boolean hasEffect(int group, int state);
	/**
		 Returns a fingerprint for the effect by encoding
		 the given <code>group</code> and <code>state</code> into a String. This
		 is useful for caching.
			@param group the group, see TDEIcon.Group
			@param state the state, see TDEIcon.States
				@return the fingerprint of the given <code>group</code>+<code>state</code>

		@short    Returns a fingerprint for the effect by encoding  the given <code>group</code> and <code>state</code> into a String.
	*/
	public native String fingerprint(int group, int state);
	/**
		 Applies an effect to an image. The effect to apply depends on the
		 <code>group</code> and <code>state</code> parameters, and is configured by the user.
			@param src The image.
			@param group The group for the icon, see TDEIcon.Group
			@param state The icon's state, see TDEIcon.States
				@return An image with the effect applied.

		@short    Applies an effect to an image.
	*/
	public native TQImage apply(TQImage src, int group, int state);
	/**
		 Applies an effect to an image.
			@param src The image.
			@param effect The effect to apply, one of TDEIconEffect.Effects.
			@param value Strength of the effect. 0 <= <code>value</code> <= 1.
			@param rgb Color parameter for effects that need one.
			@param trans Add Transparency if trans = true.
				@return An image with the effect applied.

		@short    Applies an effect to an image.
	*/
	public native TQImage apply(TQImage src, int effect, float value, TQColor rgb, boolean trans);
	/**
				@short
	*/
	public native TQImage apply(TQImage src, int effect, float value, TQColor rgb, TQColor rgb2, boolean trans);
	/**
		 Applies an effect to a pixmap.
			@param src The pixmap.
			@param group The group for the icon, see TDEIcon.Group
			@param state The icon's state, see TDEIcon.States
				@return A pixmap with the effect applied.

		@short    Applies an effect to a pixmap.
	*/
	public native TQPixmap apply(TQPixmap src, int group, int state);
	/**
		 Applies an effect to a pixmap.
			@param src The pixmap.
			@param effect The effect to apply, one of TDEIconEffect.Effects.
			@param value Strength of the effect. 0 <= <code>value</code> <= 1.
			@param rgb Color parameter for effects that need one.
			@param trans Add Transparency if trans = true.
				@return A pixmap with the effect applied.

		@short    Applies an effect to a pixmap.
	*/
	public native TQPixmap apply(TQPixmap src, int effect, float value, TQColor rgb, boolean trans);
	/**
				@short
	*/
	public native TQPixmap apply(TQPixmap src, int effect, float value, TQColor rgb, TQColor rgb2, boolean trans);
	/**
		 Returns an image twice as large, consisting of 2x2 pixels.
			@param src the image.
				@return the scaled image.

		@short    Returns an image twice as large, consisting of 2x2 pixels.
	*/
	public native TQImage doublePixels(TQImage src);
	/**
		 Provides visual feedback to show activation of an icon on a widget.
			 Not strictly an 'icon effect', but in practice that's what it looks
		 like.
			 This method does nothing if the global 'Visual feedback on activation'
		 option is not activated (See kcontrol/Peripherals/Mouse).
			@param widget The widget on which the effect should be painted
			@param rect This rectangle defines the effect's borders
		     		@short    Provides visual feedback to show activation of an icon on a widget.
	*/
	public static native void visualActivate(TQWidget widget, TQRect rect);
	/**
		 Tints an image gray.
			@param image The image
			@param value Strength of the effect. 0 <= <code>value</code> <= 1
		     		@short    Tints an image gray.
	*/
	public static native void toGray(TQImage image, float value);
	/**
		 Colorizes an image with a specific color.
			@param image The image
			@param col The color with which the <code>image</code> is tinted
			@param value Strength of the effect. 0 <= <code>value</code> <= 1
		     		@short    Colorizes an image with a specific color.
	*/
	public static native void colorize(TQImage image, TQColor col, float value);
	/**
		 Produces a monochrome icon with a given foreground and background color
			@param image The image
			@param white The color with which the white parts of <code>image</code> are painted
			@param black The color with which the black parts of <code>image</code> are painted
			@param value Strength of the effect. 0 <= <code>value</code> <= 1
				@short    Produces a monochrome icon with a given foreground and background color
	*/
	public static native void toMonochrome(TQImage image, TQColor black, TQColor white, float value);
	/**
		 Desaturates an image.
			@param image The image
			@param value Strength of the effect. 0 <= <code>value</code> <= 1
		     		@short    Desaturates an image.
	*/
	public static native void deSaturate(TQImage image, float value);
	/**
		 Changes the gamma value of an image.
			@param image The image
			@param value Strength of the effect. 0 <= <code>value</code> <= 1
		     		@short    Changes the gamma value of an image.
	*/
	public static native void toGamma(TQImage image, float value);
	/**
		 Renders an image semi-transparent.
			@param image The image
		     		@short    Renders an image semi-transparent.
	*/
	public static native void semiTransparent(TQImage image);
	/**
		 Renders a pixmap semi-transparent.
			@param pixmap The pixmap
		     		@short    Renders a pixmap semi-transparent.
	*/
	public static native void semiTransparent(TQPixmap pixmap);
	/**
		 Overlays an image with an other image.
			@param src The image
			@param overlay The image to overlay <code>src</code> with
		     		@short    Overlays an image with an other image.
	*/
	public static native void overlay(TQImage src, TQImage overlay);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
