/*
 *  Copyright (c) 2004 Szombathelyi György <gyurco@freemail.hu>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef _KUSERLDAP_H_
#define _KUSERLDAP_H_

#include <sys/types.h>

#include <tqobject.h>
#include <tqstring.h>
#include <tqptrlist.h>

#include <kprogress.h>
#include <tdeabc/ldapurl.h>
#include <tdeabc/ldif.h>
#include <tdeio/job.h>

#include "kuser.h"

class KUserLDAP : public TQObject, public KU::KUsers {
Q_OBJECT
  
public:
  KUserLDAP(KUserPrefsBase *cfg);
  virtual ~KUserLDAP();

  virtual bool reload();
  virtual bool dbcommit();

private slots:
  void data( TDEIO::Job*, const TQByteArray& );
  void putData( TDEIO::Job *job, TQByteArray& data );
  void result( TDEIO::Job* );
private:
  TDEABC::LDIF mParser;
  TDEABC::LDAPUrl mUrl;
  KProgressDialog *mProg;
  bool mOk, mCancel;
  KU::KUser *mUser, *mDelUser, *mAddUser;
  int mAdv;
  TQCString ldif;
  int schemaversion;
  TQStringList mOc;
  TQMap<KU::KUser*, TQStringList> mObjectClasses;
  
  TQString getRDN( KU::KUser *user );
  void getLDIF( KU::KUser *user, bool mod );
  void delData( KU::KUser *user );
  
  virtual void createPassword( KU::KUser *user, const TQString &password );
};

#endif // _KUSERLDAP_H_
