#ifndef __QTCURVE_H__
#define __QTCURVE_H__

/*
  QtCurve (C) Craig Drummond, 2003 - 2010 craig.p.drummond@gmail.com

  ----

  Based upon B???Curve style (Copyright (c) 2002 R?d H?t, Inc)
      Bernhard Rosenkrazer <bero@r?dh?t.com>
      Preston Brown <pbrown@r?dh?t.com>
      Than Ngo <than@r?dh?t.com>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License version 2 as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.

  ----

  B???Curve is based on the KDE Light style, 2nd revision:
  Copyright (c) 2000-2001 Trolltech AS (info@trolltech.com). The light style
  license is as follows:

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the "Software"),
  to deal in the Software without restriction, including without limitation
  the rights to use, copy, modify, merge, publish, distribute, sublicense,
  and/or sell copies of the Software, and to permit persons to whom the
  Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.
*/

#include "config.h"
#ifdef TQTC_TQT_ONLY
#include "tqtc_tdestyle.h"
#else
#include <tdeversion.h>
#include <tdestyle.h>
#endif
#include <tqcolor.h>
#include <tqpoint.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqcache.h>
#include <tqvaluelist.h>
#include "common.h"

#ifdef __cplusplus
using namespace TDEQtCurveStyle;
#endif

class TQTimer;
class TQSlider;

#ifdef TQTC_TQT_ONLY
#define BASE_STYLE TQtCTDEStyle
#else
#define BASE_STYLE TDEStyle
#endif

class ShortcutHandler;

class QtCurveStyle : public BASE_STYLE
{
    Q_OBJECT

    public:

    enum EApp
    {
        APP_KICKER,
        APP_KORN,
        APP_OPENOFFICE,
        APP_MACTOR,
        APP_KPRESENTER,
        APP_KONQUEROR,
        APP_SKIP_TASKBAR,
        APP_KPRINTER,
        APP_KDIALOG,
        APP_KDIALOGD,
        APP_TORA,
        APP_KONTACT,
        APP_OPERA,
        APP_SYSTEMSETTINGS,
        APP_KATE,
        APP_OTHER
    };

    enum EHover
    {
        HOVER_NONE,
        HOVER_CHECK,
        HOVER_RADIO,
        HOVER_SB_ADD,
        HOVER_SB_SUB,
        HOVER_SB_SUB2,
        HOVER_SB_SLIDER,
        HOVER_HEADER,
        HOVER_KICKER,
        HOVER_SW_UP,
        HOVER_SW_DOWN,
        HOVER_SW_ENTRY,
        HOVER_CB_ARROW,
        HOVER_CB_ENTRY
    };

    enum EntryColor
    {
        ENTRY_FOCUS,
        ENTRY_MOUSE_OVER,
        ENTRY_NONE
    };

#ifdef TQTC_STYLE_SUPPORT
    QtCurveStyle(const TQString &name=TQString());
#else
    QtCurveStyle();
#endif

    virtual ~QtCurveStyle();

    void applicationPolish(const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *);
    void applicationUnPolish(const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *);
    void polish(TQPalette &pal);
    TQColorGroup setColorGroup(const TQColorGroup &old, const TQColorGroup &act, bool dis=false);
    void polish(const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *);
    void unPolish(const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *);
    void drawLightBevel(TQPainter *p, const TQRect &r, const TQColorGroup &cg, SFlags flags,
                        int round, const TQColor &fill, const TQColor *custom=NULL,
                        bool doBorder=true, bool doCorners=true, EWidget w=WIDGET_OTHER, const TQWidget *widget=0L) const
    { drawLightBevel(cg.background(), p, r, cg, flags, round, fill, custom, doBorder, doCorners, w, widget); }
    void drawLightBevel(const TQColor &bgnd, TQPainter *p, const TQRect &r, const TQColorGroup &cg,
                        SFlags flags, int round, const TQColor &fill, const TQColor *custom=NULL,
                        bool doBorder=true, bool doCorners=true, EWidget w=WIDGET_OTHER, const QWidget *widget=0L) const;
    void drawGlow(TQPainter *p, const TQRect &r, const TQColorGroup &cg, EWidget w, const TQColor *cols=0) const;
    void drawEtch(TQPainter *p, const TQRect &r, const TQColorGroup &cg, bool raised=false, bool square=false, EWidget w=WIDGET_OTHER) const;
    void drawBorder(const TQColor &bgnd, TQPainter *p, const TQRect &r, const TQColorGroup &cg,
                    SFlags flags, int round, const TQColor *custom=NULL, EWidget w=WIDGET_OTHER,
                    bool doCorners=true, EBorder borderProfile=BORDER_FLAT, bool blendBorderColors=true, int borderVal=STD_BORDER) const;
    void drawMdiIcon(TQPainter *painter, const TQColor &color, const TQColor &shadow, const TQRect &r, bool sunken, int margin,
                     SubControl button) const;
    void drawWindowIcon(TQPainter *painter, const TQColor &color, const TQRect &r, bool sunken, int margin, SubControl button) const;
    void drawEntryField(TQPainter *p, const TQRect &r, const TQColorGroup &cg, SFlags flags,
                        EntryColor coloration, int round, EWidget=WIDGET_ENTRY) const;
    void drawArrow(TQPainter *p, const TQRect &r, const TQColorGroup &cg, SFlags flags,
                   TQ_PrimitiveElement pe,  bool small=false, bool checkActive=false) const;
    void drawPrimitive(TQ_PrimitiveElement, TQPainter *, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &, const TQColorGroup &,
                       SFlags = Style_Default, const TQStyleOption & = TQStyleOption::Default) const;
    void drawTDEStylePrimitive(TDEStylePrimitive kpe, TQPainter* p, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &r,
                             const TQColorGroup &cg, SFlags flags, const TQStyleOption &opt, const TQWidget* widget = 0 ) const;
    void drawControl(ControlElement, TQPainter *, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &, const TQColorGroup &,
                     SFlags = Style_Default, const TQStyleOption & = TQStyleOption::Default, const TQWidget * = 0) const;
    void drawControlMask(ControlElement, TQPainter *, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &,
                         const TQStyleOption & = TQStyleOption::Default, const TQWidget * = 0) const;
    void drawComplexControlMask(ComplexControl control, TQPainter *p, const TQStyleControlElementData &ceData, const ControlElementFlags elementFlags,
                                const TQRect &r, const TQStyleOption &data, const TQWidget *widget) const;
    TQRect subRect(SubRect, const TQStyleControlElementData &ceData, const ControlElementFlags elementFlags, const TQWidget * = 0) const;
    void drawComplexControl(ComplexControl, TQPainter *, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &,
                            const TQColorGroup &, SFlags = Style_Default, SCFlags = SC_All,
                            SCFlags = SC_None, const TQStyleOption & = TQStyleOption::Default, const TQWidget * = 0) const;
    TQRect querySubControlMetrics(TQ_ComplexControl, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, SubControl,
                                 const TQStyleOption & = TQStyleOption::Default, const TQWidget * = 0) const;
    int pixelMetric(PixelMetric, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQWidget *widget= 0) const;
    int kPixelMetric(TDEStylePixelMetric kpm, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQWidget *widget) const;
    TQSize sizeFromContents(ContentsType, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQSize &,
                           const TQStyleOption & = TQStyleOption::Default, const TQWidget * = 0) const;
    int styleHint(StyleHint, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQStyleOption & = TQStyleOption::Default,
                  TQStyleHintReturn *returnData= 0, const TQWidget *widget= 0) const;
    void drawItem(TQPainter *p, const TQRect &r, int flags, const TQColorGroup &cg, bool enabled,
                  const TQPixmap *pixmap, const TQString &text, int len=-1, const TQColor *penColor=0) const;

    protected:

    bool appIsNotEmbedded(TQDialog *dlg);
    virtual bool objectEventHandler( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void* source, TQEvent *e );
    void drawMenuItem(TQPainter *p, const TQRect &r, int flags, const TQColorGroup &cg,
                      bool mbi, int round, const TQColor &bgnd, const TQColor *cols) const;
    void drawProgress(TQPainter *p, const TQRect &r, const TQColorGroup &cg, SFlags flags, int round,
                      const TQWidget *widget) const;
    void drawBevelGradient(const TQColor &base, const TQColor &bgnd, TQPainter *p, TQRect const &r,
                           bool horiz, bool sel, EAppearance bevApp, EWidget w=WIDGET_OTHER) const;
    void drawBevelGradientReal(const TQColor &base, const TQColor &bgnd, TQPainter *p, TQRect const &r,
                               bool horiz, bool sel, EAppearance bevApp, EWidget w=WIDGET_OTHER) const;
    void drawGradient(const TQColor &top, const TQColor &bot, TQPainter *p, const TQRect &r, bool horiz=true) const;
    void drawSbSliderHandle(TQPainter *p, const TQRect &r, const TQColorGroup &cg, SFlags flags, bool slider=false) const;
    void drawSliderHandle(TQPainter *p, const TQRect &r, const TQColorGroup &cg, SFlags flags, TQSlider *slider, bool tb=false) const;
    void drawSliderGroove(TQPainter *p, const TQRect &r, const TQColorGroup &cg, SFlags flags,
                          const TQStyleControlElementData &ceData, const ControlElementFlags elementFlags, const TQWidget *widget) const;
    void drawMenuOrToolBarBackground(TQPainter *p, const TQRect &r, const TQColorGroup &cg, bool menu=true, bool horiz=true) const;
    void drawHandleMarkers(TQPainter *p, const TQRect &r, SFlags flags, bool tb, ELine handles) const;
    void drawHighlight(TQPainter *p, const TQRect &r, const TQColorGroup &cg, bool horiz, bool inc) const;

    private:

    static TQColor shadowColor(const TQColor col)
    {
        return tqGray(col.rgb()) < 100 ? TQColor(255, 255, 255) : TQColor(0, 0, 0);
    }

    void            shadeColors(const TQColor &base, TQColor *vals) const;
    const TQColor * buttonColors(const TQColorGroup &cg) const;
    const TQColor * popupMenuCols(const TQColorGroup &cg) const;
    const TQColor & popupMenuCol(const TQColorGroup &cg, int shade=ORIGINAL_SHADE) const;
    const TQColor * checkRadioColors(const TQColorGroup &cg, SFlags flags) const;
    const TQColor * sliderColors(/*const TQColorGroup &cg, */SFlags flags) const;
    const TQColor * backgroundColors(const TQColor &c) const;
    const TQColor * backgroundColors(const TQColorGroup &cg) const
                                { return backgroundColors(cg.background()); }
    const TQColor * borderColors(SFlags flags, const TQColor *use) const;
    const TQColor * getSidebarButtons() const;
    void            setMenuColors(const TQColorGroup &cg);
    void            setMenuTextColors(TQWidget *widget, bool isMenuBar) const;
    const TQColor * menuColors(const TQColorGroup &cg, bool active) const;
    void            setDecorationColors(bool init=false);
    const TQColor * getMdiColors(const TQColorGroup &cg, bool active) const;
#ifdef SET_MDI_WINDOW_BUTTON_POSITIONS
    void           readMdiPositions() const;
#endif
    bool            redrawHoverWidget(const TQPoint &pos);
    const TQColor & getFill(SFlags flags, const TQColor *use, bool cr=false, bool darker=false) const;
    const TQColor & getListViewFill(SFlags flags, const TQColor *use) const;
    const TQColor & getTabFill(bool current,  bool highlight, const TQColor *use) const;
    const TQColor & menuStripeCol(const TQColorGroup &cg) const;
    const TQColor & checkRadioCol(SFlags flags, const TQColorGroup &cg) const;
    TQColor         shade(const TQColor &a, float k) const;
    void            shade(const color &ca, color *cb, double k) const;
    void            drawDot(TQPainter *p, const TQRect &r, const TQColor *cols) const;
    TQPixmap *      getPixelPixmap(const TQColor col) const;
    TQPixmap *      getPixmap(const TQColor col, EPixmap pix, double shade=1.0) const;
    TQPixmap *      createStripePixmap(const TQColor &col, bool forWindow) const;
    void            setSbType();
    bool            isFormWidget(const TQWidget *w) const { return itsKhtmlWidgets.contains(w); }
    void            resetHover();
    bool            isWindowDragWidget(TQObject *o, const TQPoint &pos=TQPoint());
    void            adjustScrollbarRects(bool &itsFormMode, bool &horiz, bool &useThreeButtonScrollBar, TQRect &subline, TQRect &addline, TQRect &subpage, TQRect &addpage, TQRect &slider, TQRect &first, TQRect &last, TQRect &subline2, TQRect &sbRect, Options& opts, const TQWidget* widget) const;

    private slots:

    void updateProgressPos();
    void progressBarDestroyed(TQObject *bar);
    void sliderThumbMoved(int val);
    void tdehtmlWidgetDestroyed(TQObject *o);
    void hoverWidgetDestroyed(TQObject *o);

    private:

    mutable Options            opts;
    TQColor                    itsHighlightCols[TOTAL_SHADES+1],
                               itsBackgroundCols[TOTAL_SHADES+1],
                               itsMenubarCols[TOTAL_SHADES+1],
                               itsFocusCols[TOTAL_SHADES+1],
                               *itsPopupMenuCols,
                               *itsSliderCols,
                               *itsDefBtnCols,
                               *itsMouseOverCols,
                               *itsComboBtnCols,
                               *itsCheckRadioSelCols,
                               *itsSortedLvColors,
                               *itsProgressCols,
                               itsButtonCols[TOTAL_SHADES+1],
                               itsCheckRadioCol;
    mutable TQColor             *itsSidebarButtonsCols;
    mutable TQColor             *itsActiveMdiColors;
    mutable TQColor             *itsMdiColors;
    mutable TQColor             itsActiveMdiTextColor;
    mutable TQColor             itsMdiTextColor;
    mutable TQColor             itsColoredButtonCols[TOTAL_SHADES+1];
    mutable TQColor             itsColoredBackgroundCols[TOTAL_SHADES+1];
    EApp                       itsThemedApp;
    mutable TQCache<TQPixmap>    itsPixmapCache;
#if defined TQTC_TQT_ONLY || !defined TDE_VERSION || TDE_VERSION >= 0x30200
    bool                       itsIsTransKicker;
#endif
    EHover                     itsHover;
    TQPoint                     itsOldPos;
    mutable bool               itsFormMode;
    TQWidget                    *itsHoverWidget;
    int                        itsHoverSect;
    TQTab                       *itsHoverTab;
    TQPalette                   *itsMactorPal;
    TQMap<TQWidget*, int>        itsProgAnimWidgets;
    TQMap<const TQWidget*, bool> itsKhtmlWidgets;
    TQTimer                     *itsAnimationTimer;
    mutable bool               itsActive,
                               itsIsSpecialHover;
    mutable TQValueList<int>    itsMdiButtons[2]; // 0=left, 1=right
    TQWidget                    *itsDragWidget;
    bool                       itsDragWidgetHadMouseTracking;
    ShortcutHandler            *itsShortcutHandler;
};

#endif
