//
// C++ Interface: findManager
//
// Description: 
//
//
// Author: Nicolas Ternisien <nicolas.ternisien@gmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef FIND_MANAGER_H
#define FIND_MANAGER_H

//TQt includes
#include <tqobject.h>

//KDE includes
#include <kfinddialog.h>
#include <kfind.h>
#include <tdeversion.h>

//Project includes
#include "logManager.h"
#include "globals.h"

class KSystemLog;

/**
 *
 * @short Find Manager
 * @author Nicolas Ternisien <nicolas.ternisien@gmail.com>
 * @version 0.1
 */
class FindManager : public TQObject {

	Q_OBJECT
  
	
	public:
		/**
		* Default Constructor
		*/
		FindManager(KSystemLog* parent, const char* name);
		
		virtual ~FindManager();
	
	public slots:
		void slotFind();
		void slotFindNext();
		void slotFirstFind();

		void highlightSearch(const TQString& text, int matchingIndex, int matchingLength);

	private:
	
		KSystemLog* main;

		/**
		 * A pointer to the Find dialog
		 */
		KFindDialog* findDialog;

		/**
		 * The manager of the current search
		 */
		KFind* findManager;
		
		/**
		 * Previous object found
		 */
		LogListItem* previousItemFound;

		/**
		 * Current object found
		 */
		LogListItem* currentItemFound;	
};

#endif

