/*
 * KlamOnAcc class -- the non-graphical class which manages clamonacc.
 *
 * Copyright (C) 2021 Mavridis Philippe <mavridisf@gmail.com>
 */

#ifndef _KLAMONACC_H_
#define _KLAMONACC_H_

#include <tdeapplication.h>

class TDEProcess;
class KlamOnAccAlert;

class KlamOnAcc : public TQObject {
    Q_OBJECT

    public:
        KlamOnAcc( TQWidget *parent, const char *name = 0 );
        virtual ~KlamOnAcc();

        const TQObject* object() { return static_cast<TQObject*>(this); };
        const bool isActive() { return active; };
        const bool isEnabled() { return enabled; };

    public slots:
        void start();
        void stop();
        void enable();
        void disable();
        void restart();
        void toggle( bool on );

    private:
        TDEConfig *config;
        TDEProcess *childproc;
        KlamOnAccAlert *alert;
        bool enabled = false;
        bool active = false;
        bool crashed = false;

        /* These contain information about the file which triggered the alert */
        TQString vname;
        TQString fname;

        void quarantine();

        /* We use this to avoid showing two alerts for the same file, as clamonacc
        often scans the same file multiple times, triggering the alert */
        TQStringList shownAlerts;

        /* This is a wrapper for tdesu */
        TQString tdesu( TQString command, TQString caption, bool terminal = false );

    private slots:
        /* These functions are responsible for interfacing with clamonacc */
        void childExited();
        void fatalError( TQString descr );
        void processOutput( TDEProcess*, char*, int );

        /* These functions are responsible for preparing and executing the start/stop/restart commands
           They are reused by restart() to avoid calling tdesu twice */
        TQString startPrepare();
        TQString stopPrepare();
        void startProcess( TQString command );
        void stopProcess( TQString command );

    signals:
        /* This signal causes some GUI elements to update */
        void stateUpdated();
};

#endif /* _KLAMONACC_H_ */