/* This file is part of the KDE project
   Copyright (C)  2001 Montel Laurent <lmontel@mandrakesoft.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __KoInsertLink__
#define __KoInsertLink__

#include <kdialogbase.h>
#include <koffice_export.h>
class TQLineEdit;
class KURLRequester;

namespace KOfficePrivate {
/**
 * @internal
 */
class internetLinkPage : public TQWidget
{
    Q_OBJECT
  
public:
    internetLinkPage( TQWidget *parent = 0, char *name = 0 );
    TQString linkName()const;
    TQString hrefName();
    void setLinkName(const TQString & _name);
    void setHrefName(const TQString &_name);
private:
    TQString createInternetLink();
    TQLineEdit* m_linkName, *m_hrefName;
private slots:
    void textChanged ( const TQString & );
signals:
    void textChanged();
};

/**
 * @internal
 */
class bookmarkLinkPage : public TQWidget
{
    Q_OBJECT
  
public:
    bookmarkLinkPage( TQWidget *parent = 0, char *name = 0 );
    TQString linkName()const;
    TQString hrefName();
    void setLinkName(const TQString & _name);
    void setHrefName(const TQString &_name);
    void setBookmarkList(const TQStringList &bkmlist);
private:
    TQString createBookmarkLink();
    TQLineEdit* m_linkName;
    TQComboBox *m_hrefName;
private slots:
    void textChanged ( const TQString & );
signals:
    void textChanged();
};

/**
 * @internal
 */
class mailLinkPage : public TQWidget
{
    Q_OBJECT
  
public:
    mailLinkPage( TQWidget *parent = 0, char *name = 0 );
    TQString linkName()const;
    TQString hrefName();
    void setLinkName(const TQString & _name);
    void setHrefName(const TQString &_name);

private slots:
    void textChanged ( const TQString & );
private:
    TQString createMailLink();
    TQLineEdit* m_linkName, *m_hrefName;
signals:
    void textChanged();
};

/**
 * @internal
 */
class fileLinkPage : public TQWidget
{
    Q_OBJECT
  
public:
    fileLinkPage( TQWidget *parent = 0, char *name = 0 );
    TQString linkName()const;
    TQString hrefName();
    void setLinkName(const TQString & _name);
    void setHrefName(const TQString &_name);

private slots:
    void textChanged ( const TQString & );
    void slotSelectRecentFile( const TQString & );
private:
    TQString createFileLink();
    TQLineEdit* m_linkName;
    KURLRequester* m_hrefName;
signals:
    void textChanged();
};
}

/**
 * Dialog to insert links to various sources (file, Internet, mail and bookmarks).
 */
class KOFFICEUI_EXPORT KoInsertLinkDia : public KDialogBase
{
    Q_OBJECT
  
public:
    KoInsertLinkDia( TQWidget *parent, const char *name = 0,bool displayBookmarkLink=true );
    static bool createLinkDia(TQString & linkName, TQString & hrefName, const TQStringList& bkmlist, bool displayBookmarkLink = true,
                              TQWidget* parent = 0, const char* name = 0);

    //internal
    TQString linkName() const;
    TQString hrefName() const;
    void setHrefLinkName(const TQString &_href, const TQString &_link, const TQStringList & bkmlist);
protected slots:
    virtual void slotOk();
    void slotTextChanged (  );
    void tabChanged(TQWidget *);

private:
    KOfficePrivate::fileLinkPage *fileLink;
    KOfficePrivate::mailLinkPage *mailLink;
    KOfficePrivate::internetLinkPage *internetLink;
    KOfficePrivate::bookmarkLinkPage *bookmarkLink;
    TQString currentText;
};

#endif
