/* This file is part of the KDE project

   Copyright 2004 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/


#ifndef KSPREAD_GENVALIDATIONSTYLE
#define KSPREAD_GENVALIDATIONSTYLE

#include <tqdict.h>
#include <tqmap.h>

class KoXmlWriter;

namespace KSpread
{
class Validity;
class GenValidationStyle;

class GenValidationStyles
{
public:
    GenValidationStyles();
    ~GenValidationStyles();
    TQString lookup( const GenValidationStyle& style );

    typedef TQMap<GenValidationStyle, TQString> StyleMap;
    void writeStyle( KoXmlWriter& writer );

private:
    TQString makeUniqueName( const TQString& base ) const;

    /// style definition -> name
    StyleMap m_styles;
    /// name -> style   (used to check for name uniqueness)
    typedef TQMap<TQString, bool> NameMap;
    NameMap m_names;

};

class GenValidationStyle
{
public:
    explicit GenValidationStyle(Validity *_val=0) { initVal( _val ); }


    bool operator<( const GenValidationStyle &other ) const {
        if ( allowEmptyCell != other.allowEmptyCell ) return ( allowEmptyCell < other.allowEmptyCell );
        if ( condition != other.condition ) return ( condition < other.condition );
        if ( titleInfo != other.titleInfo ) return ( titleInfo < other.titleInfo );
        if ( displayValidationInformation != other.displayValidationInformation ) return ( displayValidationInformation < other.displayValidationInformation );
        if ( messageInfo != other.messageInfo ) return ( messageInfo < other.messageInfo );
        if ( messageType != other.messageType ) return ( messageType < other.messageType );
        if ( displayMessage != other.displayMessage ) return ( displayMessage < other.displayMessage );
        if ( message != other.message ) return ( message < other.message );
        if ( title != other.title ) return ( title < other.title );

        return false;
    }
private:
    TQString createValidationCondition( Validity* _val );
    TQString createTextValidationCondition( Validity* _val );
    TQString createTimeValidationCondition( Validity* _val );
    TQString createDateValidationCondition( Validity* _val );
    TQString createNumberValidationCondition( Validity* _val );
    TQString createListValidationCondition( Validity* _val );

    void initVal( Validity *_val );

    TQString allowEmptyCell;
    TQString condition;
    TQString titleInfo;
    TQString displayValidationInformation;
    TQString messageInfo;
    TQString messageType;
    TQString displayMessage;
    TQString message;
    TQString title;
    friend class GenValidationStyles;
};

} // namespace KSpread

#endif
