

#ifndef SOUNDKONVERTER_H
#define SOUNDKONVERTER_H

#include "dcopinterface.h"

#include <tdemainwindow.h>

class Config;
class Options;
class FileList;
class ProgressIndicator;
class ComboButton;
class CDManager;
class TagEngine;
class Convert;
class ReplayGainScanner;
class CuesheetEditor;
class Logger;
class LogViewer;

class TQProgressBar;
class KPushButton;
class TDEAction;
class TDEToggleAction;
class TDEActionMenu;
class KSystemTray;

/**
 * @short The main window and connections to all other classes
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class soundKonverter : public TDEMainWindow, virtual public DCOPInterface
{
    Q_OBJECT
  
public:
    /**
     * Constructor
     */
    soundKonverter();

    /**
     * Destructor
     */
    virtual ~soundKonverter();

    /**
     * When a new instance of soundKonverter should be created,
     * this function is called and all @p files are passed, that should be opened (for conversion).
     */
    void openArgFiles( const TQStringList &files );

    /**
     * When a new instance of soundKonverter should be created,
     * this function is called and all @p files are passed, that should be opened for editing the replaygain tag.
     */
    void openArgReplayGainFiles( const TQStringList &files );

    /*
     * When a new instance of soundKonverter should be created,
     * this function is called and all @p files are passed, that should be opened for repair.
     */
//     void openArgRepairFiles( const TQStringList &files );

    /**
     * When a new instance of soundKonverter should be created,
     * this function is called and instances is increased.
     */
    void increaseInstances();

    /**
     * Returns the number of 'started' instances
     */
    int getInstances() { return instances; }

    TQString device;
    TQString format;
    TQString profile;
    TQString directory;
    bool visible;
    bool autoclose;
    void setNotify( const TQString& cmd );

    /** A system tray icon that is shown, when the main window is hidden */
    KSystemTray* systemTray;

    //virtual void moveEvent( TQMoveEvent* );

protected:
    virtual bool queryClose();

private:
    /** Saves the amount of calls to create a new instance (only one instance is running at the same time) */
    int instances;

    /** All configuration information */
    Config* config;

    /** Log everything */
    Logger* logger;

    /** Show the logs */
    LogViewer* logViewer;

    /** The widget, where we can set our output options */
    Options* options;

    /** The list view with all files (for conversion) */
    FileList* fileList;

    /** Displays the current progress */
    ProgressIndicator* progressIndicator;

    /** The CD manager */
    CDManager* cdManager;

    /** The tag engine */
    TagEngine* tagEngine;

    /** The conversion engine */
    Convert* convert;

    /** The Replay Gain tool */
    ReplayGainScanner* replayGainScanner;

    /** The cuesheet editor */
    CuesheetEditor* cuesheetEditor;

    /** The combobutton for adding files */
    ComboButton* cAdd;

    /** The button to start the conversion */
    KPushButton* pStart;

    /** The button to stop the conversion */
    KPushButton* pStop;

    TDEAction* startAction;
    TDEAction* stopAction;
    TDEAction* continueAction;
    TDEAction* killAction;
    TDEActionMenu* stopActionMenu;
    TDEToggleAction* showToolBarAction;
//     TDEToggleAction* veryHighPriorityAction;
//     TDEToggleAction* highPriorityAction;
//     TDEToggleAction* normalPriorityAction;
//     TDEToggleAction* lowPriorityAction;
//     TDEToggleAction* veryLowPriorityAction;
//     TDEActionMenu* priorityActionMenu;

    int configStartPage;

private slots:
    /**
     * The conversion has started
     */
    void startedConversion();

    /**
     * The user clicked on stop/continue conversion
     */
    void stopClicked();
    void continueClicked();

    /**
     * The conversion has stopped
     */
    void stoppedConversion();
//     void priorityChanged();

    /**
     * The combobutton for adding files was clicked and the item @p index was selected
     */
    void addClicked( int index );

    void showReplayGainScanner();
    void showRepairTool();
    void showCuesheetEditor();
    void showLogViewer();
    void showConfigDialog();
    void showConfigPluginsPage();
    void showConfigEnvironmentPage();
//     void showAboutPlugins();
    void showToolbar();
    void editToolbar();
    void newToolbarConfig();
    void fileCountChanged( int );
    void setTitle( const TQString& );

    //void openCuesheetEditor( const TQString& content );

public slots:
    void showFileDialog();
    void showDirDialog();
    void showCdDialog( bool intern = true );
    void showUrlDialog();

signals:
    //void windowMoved( int x, int y );
//     void setPriority( int );
//     void addFilesToReplayGainScanner( TQStringList );
};

#endif // SOUNDKONVERTER_H
