

#ifndef OPTIONSEDITOR_H
#define OPTIONSEDITOR_H

#include <kdialogbase.h>
//#include <kpushbutton.h>

class Options;
class Config;
class TagEngine;
class FileList;
class FileListItem;

class KLineEdit;
class KComboBox;
class KIntSpinBox;
class KTextEdit;
class KPushButton;
class TQLabel;

/**
 * @short The options edit dialog that can be opened through the file list's context menu
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class OptionsEditor : public KDialogBase
{
    Q_OBJECT
  
public:
    enum Page {
        OptionsPage,
        TagsPage
    };

    /**
     * Constructor
     */
    OptionsEditor( TagEngine*, Config*, FileList* _fileList, TQWidget* parent = 0, const char* name=0, Page startPage = OptionsPage );

    /**
     * Destructor
     */
    virtual ~OptionsEditor();

    FileListItem* selectedItem();

private:
    FileList* fileList;
    Config* config;
    TagEngine* tagEngine;

    TQFrame* conversionOptions;
    TQFrame* tags;

    /** The widget, where we can set our output options */
    Options* options;

    /** A lineedit for entering the title of track */
    TQLabel* lTitleLabel;
    KLineEdit* lTitle;
    KPushButton* pTitleEdit;
    /** A spinbox for entering or selecting the track number */
    TQLabel* lNumberLabel;
    KIntSpinBox* iNumber;
    KPushButton* pNumberEdit;
    /** A lineedit for entering the artist of a track */
    TQLabel* lArtistLabel;
    KLineEdit* lArtist;
    KPushButton* pArtistEdit;
    /** A lineedit for entering the composer of a track */
    TQLabel* lComposerLabel;
    KLineEdit* lComposer;
    KPushButton* pComposerEdit;
    /** A lineedit for entering the album name */
    TQLabel* lAlbumLabel;
    KLineEdit* lAlbum;
    KPushButton* pAlbumEdit;
    /** A spinbox for entering or selecting the disc number */
    TQLabel* lDiscLabel;
    KIntSpinBox* iDisc;
    KPushButton* pDiscEdit;
    /** A spinbox for entering or selecting the year of the album */
    TQLabel* lYearLabel;
    KIntSpinBox* iYear;
    KPushButton* pYearEdit;
    /** A combobox for entering or selecting the genre of the album */
    TQLabel* lGenreLabel;
    KComboBox* cGenre;
    KPushButton* pGenreEdit;
    /** A textedit for entering a comment for a track */
    TQLabel* lCommentLabel;
    KTextEdit* tComment;
    KPushButton* pCommentEdit;

    /** When hitting this button, the options lock (when multiple files are selected) will be deactivated */
    TQLabel* lEditOptions;
    KPushButton* pEditOptions;

    /** When hitting this button, the tag lock (when reading tags failed) will be deactivated */
    TQLabel* lEditTags;
    KPushButton* pEditTags;

    //FileListItem* currentItem;
    TQValueList<FileListItem*> selectedItems;

    void setTagInputEnabled( bool enabled );

private slots:
    void optionsChanged();

    void editTitleClicked();
    void editNumberClicked();
    void editArtistClicked();
    void editComposerClicked();
    void editAlbumClicked();
    void editDiscClicked();
    void editYearClicked();
    void editGenreClicked();
    void editCommentClicked();

    void titleChanged( const TQString& text );
    void numberChanged( int value );
    void artistChanged( const TQString& text );
    void composerChanged( const TQString& text );
    void albumChanged( const TQString& text );
    void discChanged( int value );
    void yearChanged( int value );
    void genreChanged( const TQString& text );
    void commentChanged();

    void editOptionsClicked();
    void editTagsClicked();

public slots:
    void itemsSelected( TQValueList<FileListItem*> );
    void setPreviousEnabled( bool );
    void setNextEnabled( bool );
    //void moveWindow( int x, int y );

signals:
    void previousItem();
    void nextItem();
};

#endif // OPTIONSEDITOR_H
