

#ifndef CONFIGGENERALPAGE_H
#define CONFIGGENERALPAGE_H

#include <configpagebase.h>

class Config;
class TQCheckBox;
class KComboBox;
class KIntSpinBox;
class KLineEdit;
class KPushButton;

/**
 * @short The page for the general configuration
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConfigGeneralPage : public ConfigPageBase
{
    Q_OBJECT
  
public:
    /**
     * Default Constructor
     */
    ConfigGeneralPage( Config*, TQWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigGeneralPage();

private:
    KComboBox* cStartTab;
    KComboBox* cDefaultProfile;
    TQStringList sDefaultProfile;
    KComboBox* cDefaultFormat;
    TQStringList sDefaultFormat;
//     KLineEdit* lDir;
    //KPushButton* pDirInfo;
//     KPushButton* pDirSelect;
    KComboBox* cPriority;
    TQStringList sPriority;
    TQCheckBox* cUseVFATNames;
    TQStringList sConflictHandling;
    KComboBox* cConflictHandling;
    KIntSpinBox* iNumFiles;
    KIntSpinBox* iUpdateDelay;
    TQCheckBox* cAskForNewOptions;
    TQCheckBox* cExecuteUserScript;

    Config* config;

    int profileIndex( const TQString& string );
    int formatIndex( const TQString& string );

public slots:
    void resetDefaults();
    void saveSettings();

private slots:
//     void selectDir();
    void profileChanged();

};

#endif // CONFIGGENERALPAGE_H

